/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.util;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.shale.util.Messages;

public class ConverterHelper {
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", ConverterHelper.class.getClassLoader());

    public Object asObject(FacesContext context, Class type, String value) {
        if (String.class == type) {
            return value;
        }
        return this.converter(context, type).getAsObject(context, (UIComponent)context.getViewRoot(), value);
    }

    public String asString(FacesContext context, Class type, Object value) {
        if (value == null) {
            return null;
        }
        if (String.class == type && value instanceof String) {
            return (String)value;
        }
        return this.converter(context, type).getAsString(context, (UIComponent)context.getViewRoot(), value);
    }

    private Converter converter(FacesContext context, Class type) {
        if (type == null) {
            throw new ConverterException(messages.getMessage("convHelper.missing", context.getViewRoot().getLocale()));
        }
        Converter converter = null;
        try {
            converter = context.getApplication().createConverter(type);
        }
        catch (FacesException e) {
            throw new ConverterException((Throwable)e);
        }
        if (converter == null) {
            throw new ConverterException(messages.getMessage("convHelper.noConverter", context.getViewRoot().getLocale(), new Object[]{type.getName()}));
        }
        return converter;
    }
}

