/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.deploy.shared.factories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.jboss.logging.Logger;

public final class DeploymentFactoryManager {
    private static final Logger log = Logger.getLogger((Class)DeploymentFactoryManager.class);
    private static final DeploymentFactoryManager instance = new DeploymentFactoryManager();
    private Set deploymentFactories = Collections.synchronizedSet(new HashSet());

    private DeploymentFactoryManager() {
    }

    public static DeploymentFactoryManager getInstance() {
        return instance;
    }

    public DeploymentFactory[] getDeploymentFactories() {
        DeploymentFactory[] template = new DeploymentFactory[]{};
        return this.deploymentFactories.toArray(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        HashSet clone;
        Set set = this.deploymentFactories;
        synchronized (set) {
            clone = new HashSet(this.deploymentFactories);
        }
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            DeploymentFactory factory = (DeploymentFactory)i.next();
            if (!factory.handlesURI(uri)) continue;
            return factory.getDeploymentManager(uri, userName, password);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }

    public void registerDeploymentFactory(DeploymentFactory factory) {
        this.deploymentFactories.add(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        HashSet clone;
        Set set = this.deploymentFactories;
        synchronized (set) {
            clone = new HashSet(this.deploymentFactories);
        }
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            DeploymentFactory factory = (DeploymentFactory)i.next();
            if (!factory.handlesURI(uri)) continue;
            return factory.getDisconnectedDeploymentManager(uri);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }
}

