/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel.schema;

import java.util.LinkedList;
import org.jboss.aop.AspectManager;
import org.jboss.kernel.Kernel;

class DeploymentInfo {
    private Kernel kernel;
    private LinkedList manager = new LinkedList();
    private String defaultBaseName;
    private int counter;
    private static ThreadLocal deployment = new ThreadLocal();

    public static void setDeployment(DeploymentInfo di) {
        deployment.set(di);
    }

    public static DeploymentInfo getDeployment() {
        return (DeploymentInfo)deployment.get();
    }

    public DeploymentInfo(Kernel kernel, String defaultBaseName, AspectManager manager) {
        this.kernel = kernel;
        this.defaultBaseName = defaultBaseName;
        this.pushManager(manager);
    }

    public String generateName() {
        return this.defaultBaseName + this.counter++;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public AspectManager getCurrentManager() {
        return (AspectManager)this.manager.getLast();
    }

    public void pushManager(AspectManager m) {
        this.manager.add(m);
    }

    public void popManager() {
        this.manager.removeLast();
    }
}

