/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.aspects.kernel.ClassInfoPool;
import org.jboss.reflect.plugins.ClassValueImpl;
import org.jboss.reflect.plugins.EnumValueImpl;
import org.jboss.reflect.plugins.StringValueImpl;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.PrimitiveValue;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.Value;

public class MemberValueMapper
implements MemberValueVisitor {
    public Value value;
    private ClassInfoPool.Query pool;
    private TypeInfo type;

    public MemberValueMapper(ClassInfoPool.Query pool, TypeInfo type) {
        this.pool = pool;
        this.type = type;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue) {
        try {
            this.value = this.pool.getAnnotation(annotationMemberValue.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue) {
        ArrayInfo ai = (ArrayInfo)this.type;
        int size = 0;
        size = arrayMemberValue.getValue() == null || arrayMemberValue.getValue().length == 0 ? 0 : arrayMemberValue.getValue().length;
        Value[] values = new Value[size];
        MemberValue[] elements = arrayMemberValue.getValue();
        for (int i = 0; i < size; ++i) {
            MemberValueMapper creator = new MemberValueMapper(this.pool, ai.getComponentType());
            elements[i].accept((MemberValueVisitor)creator);
            values[i] = creator.value;
        }
    }

    public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue) {
        this.value = new PrimitiveValue(Boolean.toString(booleanMemberValue.getValue()), PrimitiveInfo.BOOLEAN);
    }

    public void visitByteMemberValue(ByteMemberValue byteMemberValue) {
        this.value = new PrimitiveValue(Byte.toString(byteMemberValue.getValue()), PrimitiveInfo.BYTE);
    }

    public void visitCharMemberValue(CharMemberValue charMemberValue) {
        this.value = new PrimitiveValue(Character.toString(charMemberValue.getValue()), PrimitiveInfo.CHAR);
    }

    public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue) {
        this.value = new PrimitiveValue(Double.toString(doubleMemberValue.getValue()), PrimitiveInfo.DOUBLE);
    }

    public void visitEnumMemberValue(EnumMemberValue enumMemberValue) {
        try {
            EnumInfo info = (EnumInfo)this.pool.getClassFromPools(enumMemberValue.getType());
            this.value = new EnumValueImpl((TypeInfo)info, enumMemberValue.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visitFloatMemberValue(FloatMemberValue floatMemberValue) {
        this.value = new PrimitiveValue(Float.toString(floatMemberValue.getValue()), PrimitiveInfo.FLOAT);
    }

    public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue) {
        this.value = new PrimitiveValue(Integer.toString(integerMemberValue.getValue()), PrimitiveInfo.INT);
    }

    public void visitLongMemberValue(LongMemberValue longMemberValue) {
        this.value = new PrimitiveValue(Long.toString(longMemberValue.getValue()), PrimitiveInfo.LONG);
    }

    public void visitShortMemberValue(ShortMemberValue shortMemberValue) {
        this.value = new PrimitiveValue(Short.toString(shortMemberValue.getValue()), PrimitiveInfo.SHORT);
    }

    public void visitStringMemberValue(StringMemberValue stringMemberValue) {
        this.value = new StringValueImpl(stringMemberValue.getValue(), (TypeInfo)ClassInfoPool.STRING);
    }

    public void visitClassMemberValue(ClassMemberValue classMemberValue) {
        this.value = new ClassValueImpl(classMemberValue.getValue(), (TypeInfo)ClassInfoPool.CLASS);
    }
}

