/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceDomain;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aspects.kernel.AspectClassAdapter;
import org.jboss.joinpoint.plugins.reflect.ReflectConstructorJoinPoint;
import org.jboss.reflect.spi.ConstructorInfo;

public class ClassProxyConstructorJoinpoint
extends ReflectConstructorJoinPoint {
    private Constructor wrapper;
    private AspectManager manager;
    private Map aopMetadata;
    private static volatile int counter;

    public ClassProxyConstructorJoinpoint(ConstructorInfo constructorInfo, AspectManager manager, Map aopMetadata) {
        super(constructorInfo);
        this.wrapper = constructorInfo.getConstructor();
        this.manager = manager;
        this.aopMetadata = aopMetadata;
    }

    public Object dispatch() throws Throwable {
        List metadata;
        InstanceDomain domain = new InstanceDomain(this.manager, false);
        if (this.aopMetadata != null && (metadata = (List)this.aopMetadata.get("metadata")) != null) {
            AspectClassAdapter.populateDomain(metadata, domain);
        }
        Class proxyClass = ContainerProxyFactory.getProxyClass(this.wrapper.getDeclaringClass(), (AspectManager)domain);
        ClassProxyContainer container = new ClassProxyContainer(this.wrapper.getDeclaringClass().getName() + " ClassProxy" + counter++, (AspectManager)domain);
        container.setClass(proxyClass);
        domain.setAdvisor((Advisor)container);
        container.initializeClassContainer();
        int i = 0;
        for (i = 0; i < container.getConstructors().length && !container.getConstructors()[i].equals(this.wrapper); ++i) {
            System.out.println("****: " + container.getConstructors()[i] + " : " + this.wrapper);
        }
        if (i >= container.getConstructors().length) {
            throw new RuntimeException("unable to find ClassContainer constructor");
        }
        Interceptor[] interceptors = container.getConstructorInterceptors()[i];
        Object instance = null;
        if (interceptors == null || interceptors.length == 0) {
            try {
                instance = this.wrapper.newInstance(this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        } else {
            ConstructorInvocation invocation = new ConstructorInvocation(interceptors);
            invocation.setAdvisor((Advisor)container);
            invocation.setConstructor(this.wrapper);
            instance = invocation.invokeNext();
        }
        AspectManaged proxy = (AspectManaged)proxyClass.newInstance();
        proxy.setAdvisor((Advisor)container);
        Delegate delegate = (Delegate)proxy;
        delegate.setDelegate(instance);
        return proxy;
    }
}

