/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.InstanceDomain;
import org.jboss.aop.ReflectiveAspectBinder;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aspects.kernel.AspectJoinpointFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossObject;

public class AspectClassAdapter
extends JBossObject
implements ClassAdapter {
    protected ClassInfo classInfo;
    protected Class clazz;
    protected AspectManager manager;
    protected AspectJoinpointFactory jpf;
    protected List dependencies = null;
    public static final String METADATA = "metadata";
    public static final String PER_INSTANCE = "per-instance";
    public static final String JBOSS_AOP_METADATA = "JBOSS-AOP";

    public AspectClassAdapter(AspectManager manager, Class clazz, ClassInfo classInfo) {
        this.manager = manager;
        this.clazz = clazz;
        this.classInfo = classInfo;
        this.dependencies = AspectClassAdapter.resolveDependencies(clazz, manager);
        this.jpf = this.dependencies.size() > 0 && !Advised.class.isAssignableFrom(clazz) ? new AspectJoinpointFactory(classInfo, true, manager) : new AspectJoinpointFactory(classInfo, false, manager);
    }

    public static List resolveDependencies(Class clazz, AspectManager manager) {
        ClassContainer advisor = new ClassContainer(clazz.getName(), manager);
        advisor.setClass(clazz);
        advisor.initializeMetadata();
        ReflectiveAspectBinder binder = new ReflectiveAspectBinder(clazz, (Advisor)advisor);
        Iterator it = binder.getAspects().iterator();
        ArrayList<String> depends = new ArrayList<String>();
        while (it.hasNext()) {
            AspectDefinition def = (AspectDefinition)it.next();
            depends.add(def.getName());
        }
        return depends;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public ClassAdapter getInstanceAdapter(ClassInfo classInfo) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    protected List getPerInstanceDependencies(Object obj) {
        InstanceDomain domain = new InstanceDomain(this.manager, false);
        Map map = (Map)obj;
        List metadata = (List)map.get(METADATA);
        if (metadata == null) {
            return this.dependencies;
        }
        if (AspectClassAdapter.populateDomain(metadata, domain)) {
            map.put(PER_INSTANCE, Boolean.TRUE);
        }
        return AspectClassAdapter.resolveDependencies(this.clazz, (AspectManager)domain);
    }

    public static boolean populateDomain(List metadata, InstanceDomain domain) {
        Iterator it = metadata.iterator();
        boolean hasData = false;
        while (it.hasNext()) {
            AnnotationIntroduction intro;
            hasData = true;
            Object stuff = it.next();
            if (stuff instanceof AdviceBinding) {
                AdviceBinding binding = (AdviceBinding)stuff;
                domain.addPointcut(binding.getPointcut());
                domain.addBinding(binding);
                InterceptorFactory[] factories = binding.getInterceptorFactories();
                for (int i = 0; i < factories.length; ++i) {
                    InterceptorFactory factory = factories[i];
                    if (factory.getAspect() == null) continue;
                    domain.addAspectDefinition(factory.getAspect());
                    domain.addInterceptorFactory(factory.getName(), factory);
                }
                continue;
            }
            if (stuff instanceof AnnotationIntroduction) {
                intro = (AnnotationIntroduction)stuff;
                domain.addAnnotationIntroduction(intro);
                continue;
            }
            if (stuff instanceof InterfaceIntroduction) {
                intro = (InterfaceIntroduction)stuff;
                domain.addInterfaceIntroduction((InterfaceIntroduction)intro);
                continue;
            }
            throw new RuntimeException("Cannot support the following AOP metadata within microcontainer: " + stuff.getClass().getName());
        }
        return hasData;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public JoinpointFactory getJoinpointFactory() {
        return this.jpf;
    }
}

