/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.prototype;

import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.util.id.GUID;

public class AspectBinding {
    protected AspectManager manager;
    protected String name = GUID.asString();
    protected String pointcut;
    protected AspectDefinition aspect;
    protected String method = "invoke";

    public AspectDefinition getAspect() {
        return this.aspect;
    }

    public void setAspect(AspectDefinition aspect) {
        this.aspect = aspect;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public void start() throws Exception {
        if (this.pointcut == null) {
            throw new IllegalArgumentException("Null pointcut");
        }
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.aspect == null) {
            throw new IllegalArgumentException("Null aspect definition");
        }
        AdviceBinding binding = new AdviceBinding(this.name, this.pointcut, null);
        binding.addInterceptorFactory((InterceptorFactory)new AdviceFactory(this.aspect, this.method));
        this.manager.addBinding(binding);
    }

    public void stop() throws Exception {
        this.manager.removeBinding(this.name);
    }
}

