/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.ServerAuthContext;
import javax.security.auth.container.ServerAuthModule;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.GeneralizedAuthenticationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.container.modules.AbstractServerAuthModule;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JASPISecurityManager
implements GeneralizedAuthenticationManager {
    protected String securityDomain;
    protected CallbackHandler handler;
    private Method setSecurityInfo;
    private CachePolicy domainCache;
    private ThreadLocal sharedStateLocal = new ThreadLocal();
    private List serverAuthModules = new ArrayList();
    protected Logger log;
    protected boolean trace;
    static /* synthetic */ Class class$org$jboss$security$plugins$JASPISecurityManager$DomainInfo;

    public JASPISecurityManager() {
        this("other", new SecurityAssociationHandler());
    }

    public JASPISecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger((String)categoryName);
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
        this.log.debug((Object)("CallbackHandler: " + handler));
        this.configureServerAuthModules();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        if (this.trace) {
            this.log.trace((Object)("Begin isValid, principal:" + principal + ", cache info: " + cacheInfo));
        }
        boolean isValid = false;
        if (cacheInfo != null) {
            isValid = this.validateCache(cacheInfo, credential, activeSubject);
            if (cacheInfo != null) {
                cacheInfo.release();
            }
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End isValid, " + isValid));
        }
        return isValid;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        this.updateSharedState(sharedState);
        int len = this.serverAuthModules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule sam = (ServerAuthModule)this.serverAuthModules.get(i);
            sam.disposeSubject(subject, (Map)this.sharedStateLocal.get());
        }
    }

    public MessageLayer getMessageLayer() {
        return new MessageLayer(this.securityDomain);
    }

    public void secureResponse(AuthParam authParam, Subject source, Map sharedState) throws AuthException {
        throw new IllegalStateException("NotImplemented Yet");
    }

    public void validateRequest(AuthParam authParam, Subject source, Subject recipient, Map sharedState) throws AuthException {
        if (authParam == null) {
            throw new IllegalArgumentException("Illegal Null Argument:authParam");
        }
        this.updateSharedState(sharedState);
        int len = this.serverAuthModules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule sam = (ServerAuthModule)this.serverAuthModules.get(i);
            sam.validateRequest(authParam, source, recipient, (Map)((HashMap)this.sharedStateLocal.get()));
        }
    }

    public void flushAuthenticationCache() {
        try {
            if (this.domainCache != null) {
                this.domainCache.flush();
            }
        }
        catch (Exception e2) {
            this.log.debug((Object)"flushAuthenticationCache failed", (Throwable)e2);
        }
    }

    public void flushAuthenticationCache(Principal user) {
        try {
            if (this.domainCache != null) {
                this.domainCache.remove((Object)user);
            }
        }
        catch (Exception e2) {
            this.log.debug((Object)"flushAuthenticationCache failed", (Throwable)e2);
        }
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug((Object)("CachePolicy set to: " + domainCache));
    }

    protected boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            if (this.trace) {
                this.log.trace((Object)"Failed to create/setSecurityInfo on handler", e);
            }
            throw new IllegalStateException("Failed to setSecurityInfo on handler");
        }
        int lenOfModules = this.serverAuthModules.size();
        Subject subject = new Subject();
        boolean authenticated = false;
        AuthException authException = null;
        boolean loginFailure = false;
        for (int i = 0; i < lenOfModules; ++i) {
            loginFailure = false;
            ServerAuthModule sam = (ServerAuthModule)this.serverAuthModules.get(i);
            try {
                if (sam instanceof AbstractServerAuthModule) {
                    AbstractServerAuthModule asm = (AbstractServerAuthModule)sam;
                    asm.setCallbackHandler(theHandler);
                }
                sam.validateRequest(null, subject, null, null);
            }
            catch (AuthException e) {
                if (principal != null && principal.getName() != null || this.trace) {
                    this.log.trace((Object)"Login failure", (Throwable)e);
                }
                authException = e;
                loginFailure = true;
            }
            if (subject == null || loginFailure) continue;
            if (theSubject != null) {
                SubjectActions.copySubject(subject, theSubject);
            } else {
                theSubject = subject;
            }
            authenticated = true;
            this.updateCache(subject, principal, credential, this.securityDomain);
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (DomainInfo)this.domainCache.get((Object)principal) : (DomainInfo)this.domainCache.peek((Object)principal);
            if (cacheInfo != null) {
                cacheInfo.acquire();
            }
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject updateCache(Subject subject, Principal principal, Object credential, String securityDomain) {
        if (this.domainCache == null) {
            return subject;
        }
        long lifetime = 0L;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        DomainInfo info = new DomainInfo(lifetime);
        info.serverAuthContext = this;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true);
        info.credential = credential;
        if (this.trace) {
            this.log.trace((Object)("updateCache, inputSubject=" + SubjectActions.toString(subject) + ", cacheSubject=" + SubjectActions.toString(info.subject)));
        }
        Set subjectGroups = subject.getPrincipals(Group.class);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Enumeration members;
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = subject.getPrincipals(Principal.class);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek((Object)principal) != null) {
                this.domainCache.remove((Object)principal);
            }
            this.domainCache.insert((Object)principal, (Object)info);
            if (this.trace) {
                this.log.trace((Object)("Inserted cache info: " + info));
            }
        }
        return info.subject;
    }

    protected boolean validateCache(DomainInfo info, Object credential, Subject theSubject) {
        if (this.trace) {
            StringBuffer tmp = new StringBuffer("Begin validateCache, info=");
            tmp.append(info.toString());
            tmp.append(";credential.class=");
            if (credential != null) {
                Class<?> c = credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            this.log.trace((Object)tmp.toString());
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End validateCache, isValid=" + isValid));
        }
        return isValid;
    }

    private JASPIAuthenticationInfo getAuthenticationInfo() {
        BaseAuthenticationInfo authInfo = this.getBaseAuthenticationInfo();
        if (authInfo == null) {
            throw new IllegalStateException("authInfo is null");
        }
        if (authInfo instanceof AuthenticationInfo) {
            return this.convertJaasConfigToJASPI(authInfo);
        }
        if (authInfo instanceof JASPIAuthenticationInfo) {
            return (JASPIAuthenticationInfo)authInfo;
        }
        throw new IllegalStateException("AuthenticationInfo for securityDomain=" + this.securityDomain + " not found");
    }

    private BaseAuthenticationInfo getBaseAuthenticationInfo() {
        Configuration config = Configuration.getConfiguration();
        if (!(config instanceof XMLLoginConfigImpl)) {
            throw new IllegalStateException("Configuration not an instanceof XMLLoginConfigImpl");
        }
        XMLLoginConfigImpl xmlConfig = (XMLLoginConfigImpl)config;
        BaseAuthenticationInfo bai = xmlConfig.getAuthenticationInfo(this.securityDomain);
        if (bai == null) {
            String defaultDomain = "other";
            if (this.trace) {
                this.log.trace((Object)("App Config for securityDomain=" + this.securityDomain + "not found. Defaulting to securityDomain=" + defaultDomain));
            }
            bai = xmlConfig.getAuthenticationInfo(defaultDomain);
        }
        return bai;
    }

    private JASPIAuthenticationInfo convertJaasConfigToJASPI(BaseAuthenticationInfo authInfo) {
        if (!(authInfo instanceof AuthenticationInfo)) {
            throw new IllegalArgumentException("authInfo not an instance of Jaas AuthenticationInfo");
        }
        AuthenticationInfo aInfo = (AuthenticationInfo)authInfo;
        LoginModuleStackHolder lmsh = new LoginModuleStackHolder(this.securityDomain, Arrays.asList(aInfo.getAppConfigurationEntry()));
        AuthModuleEntry authEntry = new AuthModuleEntry("org.jboss.security.auth.container.modules.DelegatingServerAuthModule", null, null);
        authEntry.setLoginModuleStackHolder(lmsh);
        JASPIAuthenticationInfo jaspi = new JASPIAuthenticationInfo(this.securityDomain);
        jaspi.add(authEntry);
        return jaspi;
    }

    private Class loadClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load " + name + "::" + e.getLocalizedMessage());
        }
    }

    private ServerAuthModule getServerAuthModule(AuthModuleEntry entry) throws AuthException {
        String errorMsg = "Cannot instantiate " + entry.getAuthModuleName() + "::";
        ServerAuthModule sam = null;
        Class authClass = null;
        try {
            authClass = this.loadClass(entry.getAuthModuleName());
            if (entry.getAuthModuleName().equals("org.jboss.security.auth.container.modules.DelegatingServerAuthModule")) {
                Constructor ctr = authClass.getConstructor(LoginModuleStackHolder.class);
                sam = (ServerAuthModule)ctr.newInstance(entry.getLoginModuleStackHolder());
            } else {
                sam = (ServerAuthModule)authClass.newInstance();
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(errorMsg + e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException(errorMsg + e.getLocalizedMessage());
        }
        Map options = entry.getOptions();
        sam.initialize(null, null, this.handler, options, false);
        return sam;
    }

    private void configureServerAuthModules() {
        JASPIAuthenticationInfo jAuthInfo = this.getAuthenticationInfo();
        AuthModuleEntry[] entries = jAuthInfo.getAuthModuleEntry();
        int lenOfEntries = entries != null ? entries.length : 0;
        for (int i = 0; i < lenOfEntries; ++i) {
            AuthModuleEntry entry = entries[i];
            try {
                this.serverAuthModules.add(this.getServerAuthModule(entry));
                continue;
            }
            catch (AuthException ae) {
                this.log.error((Object)("Configuration of server auth modules failed::" + ae.getLocalizedMessage()));
            }
        }
    }

    private void updateSharedState(Map sharedState) {
        HashMap _sharedStateMap = (HashMap)this.sharedStateLocal.get();
        if (sharedState != null) {
            if (_sharedStateMap == null) {
                _sharedStateMap = new HashMap(sharedState);
            } else {
                _sharedStateMap.putAll(sharedState);
            }
            this.sharedStateLocal.set(_sharedStateMap);
        }
    }

    public static class DomainInfo
    implements TimedCachePolicy.TimedEntry {
        private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$plugins$JASPISecurityManager$DomainInfo == null ? (class$org$jboss$security$plugins$JASPISecurityManager$DomainInfo = JASPISecurityManager.class$("org.jboss.security.plugins.JASPISecurityManager$DomainInfo")) : class$org$jboss$security$plugins$JASPISecurityManager$DomainInfo));
        private static boolean trace = log.isTraceEnabled();
        private ServerAuthContext serverAuthContext;
        private Subject subject;
        private Object credential;
        private Principal callerPrincipal;
        private long expirationTime;
        private boolean needsDestroy;
        private int activeUsers;

        public DomainInfo(long lifetime) {
            this.expirationTime = lifetime;
            if (this.expirationTime != -1L) {
                this.expirationTime *= 1000L;
            }
        }

        synchronized int acquire() {
            return this.activeUsers++;
        }

        synchronized int release() {
            int users = this.activeUsers--;
            if (this.needsDestroy && users == 0) {
                if (trace) {
                    log.trace((Object)"needsDestroy is true, doing logout");
                }
                this.logout();
            }
            return users;
        }

        synchronized void logout() {
            block4: {
                if (trace) {
                    log.trace((Object)("logout, subject=" + this.subject + ", this=" + this));
                }
                try {
                    if (this.serverAuthContext != null) {
                        this.serverAuthContext.disposeSubject(this.subject, null);
                    }
                }
                catch (Throwable e) {
                    if (!trace) break block4;
                    log.trace((Object)"Cache entry logout failed", e);
                }
            }
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            boolean isCurrent;
            boolean bl = isCurrent = this.expirationTime == -1L;
            if (!isCurrent) {
                isCurrent = this.expirationTime > now;
            }
            return isCurrent;
        }

        public boolean refresh() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (trace) {
                log.trace((Object)("destroy, subject=" + this.subject + ", this=" + this + ", activeUsers=" + this.activeUsers));
            }
            DomainInfo domainInfo = this;
            synchronized (domainInfo) {
                if (this.activeUsers == 0) {
                    this.logout();
                } else {
                    if (trace) {
                        log.trace((Object)("destroy saw activeUsers=" + this.activeUsers));
                    }
                    this.needsDestroy = true;
                }
            }
        }

        public Object getValue() {
            return this;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append(SubjectActions.toString(this.subject));
            tmp.append(",credential.class=");
            if (this.credential != null) {
                Class<?> c = this.credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            tmp.append(",expirationTime=");
            tmp.append(this.expirationTime);
            tmp.append(']');
            return tmp.toString();
        }
    }
}

