/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.MessagePolicy;
import javax.security.auth.container.ServerAuthModule;
import org.jboss.security.SimplePrincipal;

public class SimpleServerAuthModule
implements ServerAuthModule {
    private MessageLayer messageLayer = null;
    private List principals = new ArrayList();
    private Object credential = null;
    private MessagePolicy requestPolicy = null;
    private MessagePolicy responsePolicy = null;
    private CallbackHandler handler = null;
    private Map options = null;
    private boolean mustBeTransactional = false;

    public SimpleServerAuthModule(String layerName) {
        this.messageLayer = new MessageLayer(layerName);
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        subject.getPrincipals().remove(this.principals);
        subject.getPublicCredentials().remove(this.credential);
    }

    public MessageLayer getMessageLayer() {
        return this.messageLayer;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options, boolean mustBeTransactional) throws AuthException {
        this.requestPolicy = requestPolicy;
        this.responsePolicy = responsePolicy;
        this.handler = handler;
        this.options = options;
        this.mustBeTransactional = mustBeTransactional;
    }

    public void secureResponse(AuthParam param, Subject source, Map sharedState) throws AuthException {
        if (source.getPrincipals() == null) {
            throw new AuthException("Principal Set is null");
        }
        if (source.getPublicCredentials() == null) {
            throw new AuthException("Public Credentials is null");
        }
        source.getPrincipals().addAll(this.principals);
        source.getPublicCredentials().add(this.credential);
    }

    public void validateRequest(AuthParam param, Subject source, Subject recipient, Map sharedState) throws AuthException {
        Set sourceSet = source.getPrincipals(SimplePrincipal.class);
        Set recipientSet = recipient.getPrincipals(SimplePrincipal.class);
        if (sourceSet == null && recipientSet == null) {
            throw new AuthException("Principals are null");
        }
        if (sourceSet.size() != recipientSet.size()) {
            throw new AuthException("Principals size are different");
        }
        Set publicPrincipals = recipient.getPublicCredentials(SimplePrincipal.class);
        Iterator iter = publicPrincipals.iterator();
        while (iter.hasNext()) {
            this.principals.add((SimplePrincipal)iter.next());
        }
    }
}

