/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container;

import java.net.URI;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthContextFactory;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.ClientAuthConfig;
import javax.security.auth.container.ClientAuthContext;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.ServerAuthConfig;
import javax.security.auth.container.ServerAuthContext;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.auth.container.JBossClientAuthContext;
import org.jboss.security.auth.container.WebContainerServerAuthConfig;

public class JBossAuthContextFactory
extends AuthContextFactory {
    private static Logger log = Logger.getLogger((Class)JBossAuthContextFactory.class);
    private MBeanServer server = null;

    public ClientAuthContext getAuthContext(ClientAuthConfig config, String operation) throws AuthException {
        return new JBossClientAuthContext(null);
    }

    public ServerAuthContext getAuthContext(ServerAuthConfig config, String operation) throws AuthException {
        ServerAuthContext sc = null;
        try {
            if (config instanceof WebContainerServerAuthConfig) {
                WebContainerServerAuthConfig wconfig = (WebContainerServerAuthConfig)config;
                if (this.server == null) {
                    this.server = MBeanServerLocator.locateJBoss();
                }
                ObjectName oname = new ObjectName("jboss.security:service=JASPISecurityManager");
                String contextId = wconfig.getContextId();
                String securityDomain = (String)this.server.invoke(oname, "getSecurityDomain", new Object[]{contextId}, new String[]{"java.lang.String"});
                sc = (ServerAuthContext)this.server.invoke(oname, "getSecurityManager", new Object[]{securityDomain}, new String[]{"java.lang.String"});
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            log.error((Object)("Error in getAuthContext::" + e.getLocalizedMessage()));
        }
        return sc;
    }

    public ClientAuthConfig getClientAuthConfig(MessageLayer layer, URI uri, CallbackHandler handler) throws AuthException {
        final MessageLayer mlayer = layer;
        return new ClientAuthConfig(){

            public MessageLayer getMessageLayer() {
                return mlayer;
            }
        };
    }

    public ServerAuthConfig getServerAuthConfig(MessageLayer layer, URI uri, CallbackHandler handler) throws AuthException {
        if (layer != null && layer.getName() == "HTTPServlet") {
            WebContainerServerAuthConfig sconfig = new WebContainerServerAuthConfig();
            if (uri == null) {
                throw new IllegalStateException("uri is null");
            }
            sconfig.setContextId(uri.toASCIIString());
            return sconfig;
        }
        final MessageLayer mlayer = layer;
        return new ServerAuthConfig(){

            public MessageLayer getMessageLayer() {
                return mlayer;
            }
        };
    }
}

