/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.xmlDefinition;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.ComponentDefinition;
import org.apache.tiles.NoSuchDefinitionException;
import org.apache.tiles.xmlDefinition.XmlAttribute;
import org.apache.tiles.xmlDefinition.XmlDefinitionsSet;

public class XmlDefinition
extends ComponentDefinition {
    private String inherit;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$tiles$xmlDefinition$XmlDefinition == null ? (class$org$apache$tiles$xmlDefinition$XmlDefinition = XmlDefinition.class$("org.apache.tiles.xmlDefinition.XmlDefinition")) : class$org$apache$tiles$xmlDefinition$XmlDefinition));
    private boolean isVisited = false;
    static /* synthetic */ Class class$org$apache$tiles$xmlDefinition$XmlDefinition;

    public void addAttribute(XmlAttribute attribute) {
        this.putAttribute(attribute.getName(), attribute.getValue());
    }

    public void setExtends(String name) {
        this.inherit = name;
    }

    public String getExtends() {
        return this.inherit;
    }

    public boolean isExtending() {
        return this.inherit != null;
    }

    public void setIsVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public void resolveInheritance(XmlDefinitionsSet definitionsSet) throws NoSuchDefinitionException {
        if (this.isVisited || !this.isExtending()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolve definition for child name='" + this.getName() + "' extends='" + this.getExtends() + "'."));
        }
        this.setIsVisited(true);
        XmlDefinition parent = definitionsSet.getDefinition(this.getExtends());
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + this.getName() + "' can't find its ancestor '" + this.getExtends() + "'. Please check your description file.";
            log.error((Object)msg);
            throw new NoSuchDefinitionException(msg);
        }
        parent.resolveInheritance(definitionsSet);
        Iterator parentAttributes = parent.getAttributes().keySet().iterator();
        while (parentAttributes.hasNext()) {
            String name = (String)parentAttributes.next();
            if (this.getAttributes().containsKey(name)) continue;
            this.putAttribute(name, parent.getAttribute(name));
        }
        if (this.path == null) {
            this.setPath(parent.getPath());
        }
        if (this.role == null) {
            this.setRole(parent.getRole());
        }
        if (this.controller == null) {
            this.setController(parent.getController());
            this.setControllerType(parent.getControllerType());
        }
    }

    public void overload(XmlDefinition child) {
        if (child.getPath() != null) {
            this.path = child.getPath();
        }
        if (child.getExtends() != null) {
            this.inherit = child.getExtends();
        }
        if (child.getRole() != null) {
            this.role = child.getRole();
        }
        if (child.getController() != null) {
            this.controller = child.getController();
            this.controllerType = child.getControllerType();
        }
        this.attributes.putAll(child.getAttributes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

