/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.digester;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.tiles.ComponentDefinition;
import org.apache.tiles.DefinitionsFactoryException;
import org.apache.tiles.DefinitionsReader;
import org.xml.sax.SAXException;

public class DigesterDefinitionsReader
implements DefinitionsReader {
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "definitions-parser-validate";
    protected Digester digester;
    Map definitions;
    protected boolean validating = false;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 1.1//EN", "/org/apache/tiles/resources/tiles-config_1_1.dtd", "-//Apache Software Foundation//DTD Tiles Configuration 1.2//EN", "/org/apache/tiles/resources/tiles-config_1_2.dtd"};
    private boolean inited = false;

    public DigesterDefinitionsReader() {
        this.digester = new Digester();
        this.digester.setValidating(this.validating);
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(true);
        for (int i = 0; i < this.registrations.length; i += 2) {
            URL url = this.getClass().getClassLoader().getResource(this.registrations[i + 1]);
            if (url == null) continue;
            this.digester.register(this.registrations[i], url.toString());
        }
    }

    public Map read(Object source) throws DefinitionsFactoryException {
        if (!this.inited) {
            throw new DefinitionsFactoryException("Definitions reader has not been initialized.");
        }
        this.definitions = new HashMap();
        if (source == null) {
            return null;
        }
        InputStream input = null;
        try {
            input = (InputStream)source;
        }
        catch (ClassCastException e) {
            throw new DefinitionsFactoryException("Invalid source type.  Requires java.io.InputStream.", e);
        }
        try {
            this.digester.push((Object)this);
            this.digester.parse(input);
        }
        catch (SAXException e) {
            throw new DefinitionsFactoryException("XML error reading definitions.", e);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O Error reading definitions.", e);
        }
        return this.definitions;
    }

    public void init(Map params) throws DefinitionsFactoryException {
        String value;
        if (params != null && (value = (String)params.get(PARSER_VALIDATE_PARAMETER_NAME)) != null) {
            this.digester.setValidating(Boolean.valueOf(value).booleanValue());
        }
        this.initDigesterForTilesDefinitionsSyntax(this.digester);
        this.initDigesterForComponentsDefinitionsSyntax(this.digester);
        this.initDigesterForInstancesSyntax(this.digester);
        this.inited = true;
    }

    private void initDigesterForComponentsDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.tiles.xmlDefinition";
        String DEFINITION_TAG = "component-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = DEFINITION_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "addDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.tiles.xmlDefinition";
        String DEFINITION_TAG = "tiles-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = "putList";
        String DEF_LIST_TAG = DEFINITION_TAG + "/" + LIST_TAG;
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = "*/" + LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "addDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(DEF_LIST_TAG, listHandlerClass);
        digester.addSetProperties(DEF_LIST_TAG);
        digester.addSetNext(DEF_LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
        String NESTED_LIST = "*/" + LIST_TAG + "/" + LIST_TAG;
        digester.addObjectCreate(NESTED_LIST, listHandlerClass);
        digester.addSetProperties(NESTED_LIST);
        digester.addSetNext(NESTED_LIST, "add", putAttributeHandlerClass);
        String ADD_WILDCARD = "*/item";
        String menuItemDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(ADD_WILDCARD, menuItemDefaultClass, "classtype");
        digester.addSetNext(ADD_WILDCARD, "add", "java.lang.Object");
        digester.addSetProperties(ADD_WILDCARD);
        String BEAN_TAG = "*/bean";
        String beanDefaultClass = "org.apache.tiles.beans.SimpleMenuItem";
        digester.addObjectCreate(BEAN_TAG, beanDefaultClass, "classtype");
        digester.addSetNext(BEAN_TAG, "add", "java.lang.Object");
        digester.addSetProperties(BEAN_TAG);
        digester.addSetProperty(BEAN_TAG + "/set-property", "property", "value");
    }

    private void initDigesterForInstancesSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.tiles.xmlDefinition";
        String INSTANCE_TAG = "component-instances/instance";
        String instanceHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = INSTANCE_TAG + "/put";
        String PUTATTRIBUTE_TAG = INSTANCE_TAG + "/putAttribute";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = INSTANCE_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(INSTANCE_TAG, instanceHandlerClass);
        digester.addSetProperties(INSTANCE_TAG);
        digester.addSetNext(INSTANCE_TAG, "addDefinition", instanceHandlerClass);
        digester.addObjectCreate(PUTATTRIBUTE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUTATTRIBUTE_TAG);
        digester.addSetNext(PUTATTRIBUTE_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
    }

    public void addDefinition(ComponentDefinition definition) {
        this.definitions.put(definition.getName(), definition);
    }
}

