/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.ComponentDefinitions;
import org.apache.tiles.DefinitionsFactory;
import org.apache.tiles.DefinitionsFactoryException;
import org.apache.tiles.DefinitionsReader;
import org.apache.tiles.ReloadableDefinitionsFactory;
import org.apache.tiles.definition.ComponentDefinitionsImpl;
import org.apache.tiles.digester.DigesterDefinitionsReader;
import org.apache.tiles.util.RequestUtils;

public class UrlDefinitionsFactory
implements DefinitionsFactory,
ReloadableDefinitionsFactory {
    private List sources = new ArrayList();
    private DefinitionsReader reader;
    private Map lastModifiedDates = new HashMap();
    private List processedLocales = new ArrayList();
    private String definitionsClassName;

    public void init(Map params) throws DefinitionsFactoryException {
        if (params != null) {
            String readerClassName = (String)params.get("org.apache.tiles.DefinitionsReader");
            if (readerClassName != null) {
                try {
                    Class readerClass = RequestUtils.applicationClass(readerClassName);
                    this.reader = (DefinitionsReader)readerClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new DefinitionsFactoryException("Cannot find reader class.", e);
                }
                catch (InstantiationException e) {
                    throw new DefinitionsFactoryException("Unable to instantiate reader class.", e);
                }
                catch (IllegalAccessException e) {
                    throw new DefinitionsFactoryException("Unable to access reader class.", e);
                }
            }
            this.definitionsClassName = (String)params.get("org.apache.tiles.ComponentDefinitions");
            if (this.definitionsClassName != null) {
                ComponentDefinitions componentDefinitions = this.createDefinitionsImpl(this.definitionsClassName);
            }
        }
        if (this.reader == null) {
            this.reader = new DigesterDefinitionsReader();
        }
        this.reader.init(params);
    }

    public void addSource(Object source) throws DefinitionsFactoryException {
        if (source == null) {
            throw new DefinitionsFactoryException("Source object must not be null");
        }
        if (!(source instanceof URL)) {
            throw new DefinitionsFactoryException("Source object must be an URL");
        }
        this.sources.add(source);
    }

    public void addDefinitions(ComponentDefinitions definitions, Locale locale) throws DefinitionsFactoryException {
        List postfixes = UrlDefinitionsFactory.calculatePostixes(locale);
        if (this.isLocaleProcessed(locale)) {
            return;
        }
        this.processedLocales.add(locale);
        for (int i = 0; i < this.sources.size(); ++i) {
            URL url = (URL)this.sources.get(i);
            String path = url.toExternalForm();
            for (int j = 0; j < postfixes.size(); ++j) {
                String newPath = this.concatPostfix(path, (String)postfixes.get(j));
                try {
                    URL newUrl = new URL(newPath);
                    URLConnection connection = newUrl.openConnection();
                    connection.connect();
                    this.lastModifiedDates.put(newUrl.toExternalForm(), new Long(connection.getLastModified()));
                    Map defsMap = this.reader.read(connection.getInputStream());
                    definitions.addDefinitions(defsMap, locale);
                    continue;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (IOException e) {
                    throw new DefinitionsFactoryException("I/O error processing configuration.");
                }
            }
        }
    }

    public ComponentDefinitions readDefinitions() throws DefinitionsFactoryException {
        ComponentDefinitions definitions = this.createDefinitionsImpl(this.definitionsClassName);
        try {
            for (int i = 0; i < this.sources.size(); ++i) {
                URL source = (URL)this.sources.get(i);
                URLConnection connection = source.openConnection();
                connection.connect();
                this.lastModifiedDates.put(source.toExternalForm(), new Long(connection.getLastModified()));
                Map defsMap = this.reader.read(connection.getInputStream());
                definitions.addDefinitions(defsMap);
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O error accessing source.", e);
        }
        return definitions;
    }

    public boolean isLocaleProcessed(Locale locale) {
        return this.processedLocales.contains(locale);
    }

    private String concatPostfix(String name, String postfix) {
        if (postfix == null) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }

    private static List calculatePostixes(Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        ArrayList<String> result = new ArrayList<String>();
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer();
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(temp.toString());
        return result;
    }

    protected ComponentDefinitions createDefinitionsImpl(String classname) throws DefinitionsFactoryException {
        ComponentDefinitions definitions = null;
        if (classname != null) {
            try {
                Class defsClass = RequestUtils.applicationClass(classname);
                definitions = (ComponentDefinitions)defsClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new DefinitionsFactoryException("Cannot find definitions class.", e);
            }
            catch (InstantiationException e) {
                throw new DefinitionsFactoryException("Unable to instantiate definitions class.", e);
            }
            catch (IllegalAccessException e) {
                throw new DefinitionsFactoryException("Unable to access definitions class.", e);
            }
        }
        if (definitions == null) {
            definitions = new ComponentDefinitionsImpl();
        }
        return definitions;
    }

    public boolean refreshRequired() {
        boolean status = false;
        Set urls = this.lastModifiedDates.keySet();
        try {
            Iterator i = urls.iterator();
            while (i.hasNext()) {
                String urlPath = (String)i.next();
                Long lastModifiedDate = (Long)this.lastModifiedDates.get(urlPath);
                URL url = new URL(urlPath);
                URLConnection connection = url.openConnection();
                connection.connect();
                long newModDate = connection.getLastModified();
                if (newModDate == lastModifiedDate) continue;
                status = true;
                break;
            }
        }
        catch (Exception e) {
            return true;
        }
        return status;
    }
}

