/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import java.io.InputStream;
import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.xml.SingletonSchemaResolverFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

public class BeanXMLDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)BeanXMLDeployer.class);
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();

    public BeanXMLDeployer(Kernel kernel) throws Throwable {
        super(kernel);
    }

    public KernelDeployment deploy(URL url) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (trace) {
            log.trace((Object)("Parsing " + url));
        }
        long start = System.currentTimeMillis();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
        if (deployment == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(url.toString());
        long now = System.currentTimeMillis();
        log.debug((Object)("Parsing " + url + " took " + (now - start) + " milliseconds"));
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        now = System.currentTimeMillis();
        log.debug((Object)("Deploying " + url + " took " + (now - start) + " milliseconds"));
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }

    public KernelDeployment deploy(String deploymentName, InputStream stream) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment deployment;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Parsing " + deploymentName));
        }
        if ((deployment = (KernelDeployment)(unmarshaller = factory.newUnmarshaller()).unmarshal(stream, resolver)) == null) {
            throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
        }
        deployment.setName(deploymentName);
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }
}

