/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.resource.spi.ResourceAdapter;
import org.jboss.deployment.DeploymentException;
import org.jboss.resource.deployment.DummyResourceAdapter;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;

public class ResourceAdapterFactory {
    public static final String DUMMY_RA_CLASS = DummyResourceAdapter.class.getName();

    public static ResourceAdapter createResourceAdapter(ConnectorMetaData cmd) throws Exception {
        Class<?> raClass;
        String className = cmd.getRAClass();
        if (className == null) {
            if (cmd.getVersion().equals("1.0")) {
                className = DUMMY_RA_CLASS;
            } else {
                throw new IllegalArgumentException("No resource adapter class name specified");
            }
        }
        if (!ResourceAdapter.class.isAssignableFrom(raClass = Thread.currentThread().getContextClassLoader().loadClass(className))) {
            throw new DeploymentException(raClass.getName() + " is not a resource adapter class");
        }
        ResourceAdapter result = (ResourceAdapter)raClass.newInstance();
        Iterator i = cmd.getProperties().iterator();
        while (i.hasNext()) {
            ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
            String name = cpmd.getName();
            String type = cpmd.getType();
            String value = cpmd.getValue();
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
            PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
            if (editor == null) {
                throw new IllegalArgumentException("No property editor found for property " + cpmd);
            }
            editor.setAsText(value);
            Object object = editor.getValue();
            try {
                String setter = "set" + Character.toUpperCase(name.charAt(0));
                if (name.length() > 1) {
                    setter = setter.concat(name.substring(1));
                }
                Method method = raClass.getMethod(setter, clazz);
                method.invoke((Object)result, object);
            }
            catch (InvocationTargetException e) {
                DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + raClass.getName() + " setting property " + cpmd), (Throwable)e.getTargetException());
            }
            catch (Throwable t) {
                DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + raClass.getName() + " accessing property setter " + cpmd), (Throwable)t);
            }
        }
        return result;
    }
}

