/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view;

import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public abstract class AbstractFacesBean {
    protected Application getApplication() {
        return FacesContext.getCurrentInstance().getApplication();
    }

    protected Map getApplicationMap() {
        return this.getExternalContext().getApplicationMap();
    }

    protected ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Lifecycle getLifecycle() {
        String lifecycleId = this.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null || lifecycleId.length() == 0) {
            lifecycleId = "DEFAULT";
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        return lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected Map getRequestHeaderMap() {
        return this.getExternalContext().getRequestHeaderMap();
    }

    protected Map getRequestMap() {
        return this.getExternalContext().getRequestMap();
    }

    protected Map getRequestParameterMap() {
        return this.getExternalContext().getRequestParameterMap();
    }

    protected Map getSessionMap() {
        return this.getExternalContext().getSessionMap();
    }

    protected Object getBean(String name) {
        FacesContext context = this.getFacesContext();
        return context.getApplication().getVariableResolver().resolveVariable(context, name);
    }

    protected void setBean(String name, Object value) {
        this.setValue("#{" + name + "}", value);
    }

    protected Object getValue(String expr) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        return vb.getValue(this.getFacesContext());
    }

    protected void setValue(String expr, Object value) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        vb.setValue(this.getFacesContext(), value);
    }

    protected void log(String message) {
        this.getExternalContext().log(message);
    }

    protected void log(String message, Throwable throwable) {
        this.getExternalContext().log(message, throwable);
    }

    protected void info(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void info(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void warn(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void warn(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void error(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void error(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void fatal(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }

    protected void fatal(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }
}

