/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.validator;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.xml.sax.SAXException;

public class CommonsValidator
implements Validator,
Serializable {
    private static Logger logger = Logger.getLogger("org.apache.shale.validator");
    private static Map standardTypes;
    private static final Log log;
    private String type;
    private String message;
    private String arg;
    private Boolean client;
    private Boolean server;
    private Double min;
    private Double max;
    private Integer minlength;
    private Integer maxlength;
    private String mask;
    private String datePatternStrict;
    private LinkedHashMap params;
    private transient ValidatorAction validatorAction;
    private transient Method validatorMethod;
    private transient Class[] paramTypes;
    private transient Object validator;

    public void setType(String newValue) {
        this.type = newValue;
    }

    public String getType() {
        return this.type;
    }

    public void setClient(Boolean newValue) {
        this.client = newValue;
    }

    public Boolean getClient() {
        return this.client;
    }

    public void setServer(Boolean newValue) {
        this.server = newValue;
    }

    public Boolean getServer() {
        return this.server;
    }

    public void setMessage(String newValue) {
        this.message = newValue;
    }

    public String getMessage() {
        return this.message;
    }

    public void setArg(String newValue) {
        this.arg = newValue;
    }

    public String getArg() {
        return this.arg;
    }

    public void setMin(Double newValue) {
        this.min = newValue;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMax(Double newValue) {
        this.max = newValue;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMinLength(Integer newValue) {
        this.minlength = newValue;
    }

    public Integer getMinLength() {
        return this.minlength;
    }

    public void setMaxLength(Integer newValue) {
        this.maxlength = newValue;
    }

    public Integer getMaxLength() {
        return this.maxlength;
    }

    public void setMask(String newValue) {
        this.mask = newValue;
    }

    public String getMask() {
        return this.mask;
    }

    public void setDatePatternStrict(String newValue) {
        this.datePatternStrict = newValue;
    }

    public String getDatePatternStrict() {
        return this.datePatternStrict;
    }

    public void addParam(Object key, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        this.params.put(key, value);
    }

    public Object[] getParams() {
        if (this.params == null || this.params.size() == 0) {
            ArrayList<Object> r = new ArrayList<Object>();
            if (this.min != null) {
                r.add(this.min);
            }
            if (this.max != null) {
                r.add(this.max);
            }
            if (this.minlength != null) {
                r.add(this.minlength);
            }
            if (this.maxlength != null) {
                r.add(this.maxlength);
            }
            if (this.mask != null) {
                r.add(this.mask);
            }
            if (this.datePatternStrict != null) {
                r.add(this.datePatternStrict);
            }
            return r.toArray();
        }
        return this.params.values().toArray();
    }

    public String[] getParamNames() {
        if (this.params == null || this.params.size() == 0) {
            ArrayList<String> r = new ArrayList<String>();
            if (this.min != null) {
                r.add("min");
            }
            if (this.max != null) {
                r.add("max");
            }
            if (this.minlength != null) {
                r.add("minlength");
            }
            if (this.maxlength != null) {
                r.add("maxlength");
            }
            if (this.mask != null) {
                r.add("mask");
            }
            if (this.datePatternStrict != null) {
                r.add("datePatternStrict");
            }
            return r.toArray(new String[r.size()]);
        }
        return this.params.keySet().toArray(new String[this.params.keySet().size()]);
    }

    public static ValidatorAction getValidatorAction(String name) {
        String VALIDATOR_RESOURCES_KEY = "org.apache.shale.validator.resources";
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext external = context.getExternalContext();
        Map applicationMap = external.getApplicationMap();
        ValidatorResources validatorResources = (ValidatorResources)applicationMap.get("org.apache.shale.validator.resources");
        if (validatorResources == null) {
            try {
                String pathnames = external.getInitParameter("org.apache.shale.validator.VALIDATOR_RULES");
                if (pathnames == null || pathnames.length() <= 0) {
                    pathnames = "/org/apache/shale/validator/validator-rules.xml";
                }
                StringTokenizer st = new StringTokenizer(pathnames, ",");
                ArrayList<URL> urlList = new ArrayList<URL>();
                while (st.hasMoreTokens()) {
                    String validatorRules = st.nextToken().trim();
                    logger.log(Level.INFO, "Loading validation rules file from '" + validatorRules + "'");
                    URL input = external.getResource(validatorRules);
                    if (input == null) {
                        input = (class$org$apache$shale$validator$CommonsValidator == null ? CommonsValidator.class$("org.apache.shale.validator.CommonsValidator") : class$org$apache$shale$validator$CommonsValidator).getResource(validatorRules);
                    }
                    if (input != null) {
                        urlList.add(input);
                        continue;
                    }
                    logger.log(Level.WARNING, "Skipping validation rules file from '" + validatorRules + "'.  No url could be located.");
                }
                int urlSize = urlList.size();
                String[] urlArray = new String[urlSize];
                for (int urlIndex = 0; urlIndex < urlSize; ++urlIndex) {
                    URL url = (URL)urlList.get(urlIndex);
                    urlArray[urlIndex] = url.toExternalForm();
                }
                validatorResources = new ValidatorResources(urlArray);
                applicationMap.put("org.apache.shale.validator.resources", validatorResources);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can't initialize resources", ex);
                return null;
            }
            catch (SAXException ex) {
                logger.log(Level.SEVERE, "can't initialize resources", ex);
                return null;
            }
        }
        return validatorResources.getValidatorAction(name);
    }

    public ValidatorAction getValidatorAction() {
        if (this.validatorAction == null) {
            this.validatorAction = CommonsValidator.getValidatorAction(this.type);
        }
        return this.validatorAction;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        if (Boolean.FALSE.equals(this.server)) {
            return;
        }
        this.initValidation();
        Object[] p = this.getParams();
        Object[] params = new Object[p.length + 1];
        params[0] = CommonsValidator.convert(value, this.paramTypes[0], component);
        for (int i = 1; i < params.length; ++i) {
            params[i] = CommonsValidator.convert(p[i - 1], this.paramTypes[i], null);
        }
        try {
            Boolean r = (Boolean)this.validatorMethod.invoke(this.validator, params);
            if (r.equals(Boolean.FALSE)) {
                Object errorValue = value;
                if (component instanceof EditableValueHolder) {
                    errorValue = ((EditableValueHolder)component).getSubmittedValue();
                }
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, this.getErrorMessage(errorValue, context), null));
            }
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "can't invoke validator", ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, "can't invoke validator", ex);
        }
    }

    public void initValidation() {
        if (this.validatorMethod != null) {
            return;
        }
        this.getValidatorAction();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            String methodParams = this.validatorAction.getMethodParams();
            StringTokenizer st = new StringTokenizer(methodParams, ",");
            ArrayList<String> params = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String value = st.nextToken().trim();
                if (value == null || value.length() <= 0) continue;
                params.add(value);
            }
            this.paramTypes = new Class[params.size()];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                String paramTypeName = (String)params.get(i);
                this.paramTypes[i] = (Class)standardTypes.get(paramTypeName);
                if (this.paramTypes[i] != null) continue;
                this.paramTypes[i] = classLoader.loadClass(paramTypeName);
            }
            Class<?> c = classLoader.loadClass(this.validatorAction.getClassname());
            this.validatorMethod = c.getMethod(this.validatorAction.getMethod(), this.paramTypes);
            if (!Modifier.isStatic(this.validatorMethod.getModifiers())) {
                this.validator = c.newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, "can't load validator or param class", ex);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.SEVERE, "can't get validator method", ex);
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "can't instantiate validator", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "can't instantiate validator", ex);
        }
    }

    public String getErrorMessage(Object value, FacesContext context) {
        String DEFAULT_BUNDLE_NAME = "org.apache.shale.validator.messages";
        Locale locale = context.getViewRoot().getLocale();
        String msg = this.message;
        if (msg == null) {
            ResourceBundle bundle;
            Application app;
            String appBundleName;
            String msgkey = this.validatorAction.getMsg();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            if ((appBundleName = (app = context.getApplication()).getMessageBundle()) != null && (bundle = ResourceBundle.getBundle(appBundleName, locale, loader)) != null) {
                try {
                    msg = bundle.getString(msgkey);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            if (msg == null && (bundle = ResourceBundle.getBundle("org.apache.shale.validator.messages", locale, loader)) != null) {
                try {
                    msg = bundle.getString(msgkey);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
        }
        Object[] p = this.getParams();
        Object[] params = new Object[p.length + 1];
        params[0] = value;
        for (int i = 1; i < params.length; ++i) {
            params[i] = p[i - 1];
        }
        msg = new MessageFormat(msg, locale).format(params);
        return msg;
    }

    private static Object convert(Object obj, Class cl, UIComponent component) {
        if (cl.isInstance(obj)) {
            return obj;
        }
        if (cl == String.class && component != null && component instanceof EditableValueHolder) {
            return ((EditableValueHolder)component).getSubmittedValue();
        }
        if (cl == String.class) {
            return "" + obj;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (cl == Boolean.TYPE) {
                return Boolean.valueOf(str);
            }
            if (cl == Byte.TYPE) {
                return new Byte(str);
            }
            if (cl == Character.TYPE) {
                return new Character(str.charAt(0));
            }
            if (cl == Double.TYPE) {
                return new Double(str);
            }
            if (cl == Float.TYPE) {
                return new Float(str);
            }
            if (cl == Integer.TYPE) {
                return new Integer(str);
            }
            if (cl == Long.TYPE) {
                return new Long(str);
            }
            if (cl == Short.TYPE) {
                return new Short(str);
            }
        } else if (obj instanceof Number) {
            Number num = (Number)obj;
            if (cl == Byte.TYPE) {
                return new Byte(num.byteValue());
            }
            if (cl == Double.TYPE) {
                return new Double(num.doubleValue());
            }
            if (cl == Float.TYPE) {
                return new Float(num.floatValue());
            }
            if (cl == Integer.TYPE) {
                return new Integer(num.intValue());
            }
            if (cl == Long.TYPE) {
                return new Long(num.longValue());
            }
            if (cl == Short.TYPE) {
                return new Short(num.shortValue());
            }
        }
        return obj;
    }

    public static boolean isSupplied(String str) {
        return str.trim().length() > 0;
    }

    public static boolean isDate(String d, String datePatternStrict) {
        return GenericValidator.isDate((String)d, (String)datePatternStrict, (boolean)true);
    }

    static {
        log = LogFactory.getLog((Class)CommonsValidator.class);
        standardTypes = new HashMap();
        standardTypes.put("boolean", Boolean.TYPE);
        standardTypes.put("byte", Byte.TYPE);
        standardTypes.put("char", Character.TYPE);
        standardTypes.put("double", Double.TYPE);
        standardTypes.put("float", Float.TYPE);
        standardTypes.put("int", Integer.TYPE);
        standardTypes.put("long", Long.TYPE);
        standardTypes.put("short", Short.TYPE);
        standardTypes.put("java.lang.String", String.class);
    }
}

