/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.shale.remote.MapEntry;

final class ContextAttributes
implements Map {
    private ServletContext context = null;

    public ContextAttributes(ServletContext context) {
        this.context = context;
    }

    public void clear() {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            this.context.removeAttribute((String)keys.next());
        }
    }

    public boolean containsKey(Object key) {
        return this.context.getAttribute(this.key(key)) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.context.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MapEntry> set = new HashSet<MapEntry>();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add(new MapEntry(key, this.context.getAttribute(key), true));
        }
        return set;
    }

    public boolean equals(Object o) {
        return this.context.equals(o);
    }

    public Object get(Object key) {
        return this.context.getAttribute(this.key(key));
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet set = new HashSet();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = this.context.getAttribute(skey);
        this.context.setAttribute(skey, value);
        return previous;
    }

    public void putAll(Map map) {
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.context.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        String skey = this.key(key);
        Object previous = this.context.getAttribute(skey);
        this.context.removeAttribute(skey);
        return previous;
    }

    public int size() {
        int n = 0;
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration keys = this.context.getAttributeNames();
        while (keys.hasMoreElements()) {
            list.add(this.context.getAttribute((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

