/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.http.interfaces.Util;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

public class HttpNamingContextFactory
implements InitialContextFactory,
ObjectFactory {
    private static Logger log = Logger.getLogger(HttpNamingContextFactory.class);

    public Context getInitialContext(Hashtable env) throws NamingException {
        String provider = (String)env.get("java.naming.provider.url");
        if (provider.startsWith("jnp:")) {
            provider = "http:" + provider.substring(4);
        } else if (provider.startsWith("jnps:")) {
            provider = "https:" + provider.substring(5);
        } else if (provider.startsWith("jnp-http:")) {
            provider = "http:" + provider.substring(9);
        } else if (provider.startsWith("jnp-https:")) {
            provider = "https:" + provider.substring(10);
        }
        URL providerURL = null;
        Naming namingServer = null;
        try {
            providerURL = new URL(provider);
            namingServer = this.getNamingServer(providerURL);
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Failed to retrieve Naming interface");
            ex.setRootCause(e);
            throw ex;
        }
        env = (Hashtable)env.clone();
        return new NamingContext(env, null, namingServer);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = this.getInitialContext(env);
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("URL");
        String path = (String)addr.getContent();
        return ctx.lookup(path);
    }

    private Naming getNamingServer(URL providerURL) throws ClassNotFoundException, IOException, InvocationTargetException, IllegalAccessException {
        Util.init();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Retrieving content from : " + providerURL));
        }
        HttpURLConnection conn = (HttpURLConnection)providerURL.openConnection();
        Util.configureHttpsHostVerifier(conn);
        Util.configureSSLSocketFactory(conn);
        int length = conn.getContentLength();
        String type = conn.getContentType();
        if (log.isTraceEnabled()) {
            log.trace((Object)("ContentLength: " + length + "\nContentType: " + type));
        }
        InputStream is = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(is);
        MarshalledValue mv = (MarshalledValue)ois.readObject();
        ois.close();
        Object obj = mv.get();
        if (!(obj instanceof Naming)) {
            String msg = "Invalid reply content seen: " + obj.getClass();
            Throwable t = null;
            if (obj instanceof Throwable && (t = (Throwable)obj) instanceof InvocationException) {
                t = ((InvocationException)t).getTargetException();
            }
            if (t != null) {
                log.warn((Object)msg, t);
            } else {
                log.warn((Object)msg);
            }
            IOException e = new IOException(msg);
            throw e;
        }
        Naming namingServer = (Naming)obj;
        return namingServer;
    }
}

