/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class QueryMetaData
extends MetaData {
    public static final String REMOTE = "Remote";
    public static final String LOCAL = "Local";
    private String description;
    private String methodName;
    private ArrayList methodParams = new ArrayList();
    private String resultTypeMapping;
    private String ejbQl;

    public String getDescription() {
        return this.description;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Iterator getMethodParams() {
        return this.methodParams.iterator();
    }

    public String getResultTypeMapping() {
        return this.resultTypeMapping;
    }

    public String getEjbQl() {
        return this.ejbQl;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.description = QueryMetaData.getOptionalChildContent(element, "description");
        Element queryMethod = QueryMetaData.getUniqueChild(element, "query-method");
        this.methodName = QueryMetaData.getUniqueChildContent(queryMethod, "method-name");
        Element methodParamsElement = QueryMetaData.getUniqueChild(queryMethod, "method-params");
        Iterator iterator = QueryMetaData.getChildrenByTagName(methodParamsElement, "method-param");
        while (iterator.hasNext()) {
            String param = QueryMetaData.getElementContent((Element)iterator.next());
            if (param == null || param.trim().length() == 0) {
                throw new DeploymentException("method-param tag has no value for method: " + this.methodName);
            }
            this.methodParams.add(param);
        }
        this.resultTypeMapping = QueryMetaData.getOptionalChildContent(element, "result-type-mapping");
        if (this.resultTypeMapping == null || LOCAL.equals(this.resultTypeMapping)) {
            this.resultTypeMapping = LOCAL;
        } else if (REMOTE.equals(this.resultTypeMapping)) {
            this.resultTypeMapping = REMOTE;
        } else {
            throw new DeploymentException("result-type-mapping must be 'Remote' or 'Local', if specified");
        }
        this.ejbQl = QueryMetaData.getElementContent(QueryMetaData.getUniqueChild(element, "ejb-ql"));
    }
}

