/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class UnifiedInvokerProxy
implements Invoker,
Externalizable {
    static final long serialVersionUID = -1108158470271861548L;
    private transient Client client;
    private InvokerLocator locator;
    private boolean strictRMIException = false;
    private String subsystem = "invoker";
    protected final Logger log = Logger.getLogger(this.getClass());
    static final int VERSION_5_0 = 500;
    static final int CURRENT_VERSION = 500;

    public UnifiedInvokerProxy() {
    }

    public UnifiedInvokerProxy(InvokerLocator locator) {
        this.init(locator);
    }

    public UnifiedInvokerProxy(InvokerLocator locator, boolean isStrictRMIException) {
        this.strictRMIException = isStrictRMIException;
        this.init(locator);
    }

    protected void init(InvokerLocator locator) {
        this.locator = locator;
        try {
            this.client = new Client(locator, this.getSubSystem());
            this.client.connect();
        }
        catch (Exception e) {
            this.log.fatal((Object)"Could not initialize UnifiedInvokerProxy.", (Throwable)e);
        }
    }

    public String getSubSystem() {
        return this.subsystem;
    }

    public void setSubSystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public boolean isStrictRMIException() {
        return this.strictRMIException;
    }

    protected Client getClient() {
        return this.client;
    }

    protected InvokerLocator getLocator() {
        return this.locator;
    }

    protected void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    protected void setStrictRMIException(boolean strictRMIException) {
        this.strictRMIException = strictRMIException;
    }

    public String getServerHostName() throws Exception {
        if (this.locator != null) {
            return this.locator.getHost();
        }
        return null;
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object response = null;
        try {
            response = this.client.invoke((Object)invocation, null);
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            if (response instanceof MarshalledObject) {
                return ((MarshalledObject)response).get();
            }
            return response;
        }
        catch (RemoteException aex) {
            if (this.strictRMIException) {
                throw new ServerException(aex.getMessage(), aex);
            }
            throw aex;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(500);
        out.writeUTF(this.locator.getOriginalURI());
        out.writeBoolean(this.strictRMIException);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 500: {
                this.locator = new InvokerLocator(in.readUTF());
                this.strictRMIException = in.readBoolean();
                this.init(this.locator);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown version seen: " + version);
            }
        }
    }
}

