/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import javax.ejb.TimerService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.txtimer.EJBTimerService;
import org.jboss.ejb.txtimer.EJBTimerServiceImpl;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;

public class EJBTimerServiceLocator {
    private static Logger log = Logger.getLogger(EJBTimerServiceLocator.class);
    private static EJBTimerService ejbTimerService;

    public static EJBTimerService getEjbTimerService() {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (server != null && server.isRegistered(EJBTimerService.OBJECT_NAME)) {
                ejbTimerService = new MBeanDelegate(server);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (ejbTimerService == null) {
            EJBTimerServiceImpl ejbTimerServiceImpl = new EJBTimerServiceImpl();
            ejbTimerService = ejbTimerServiceImpl;
            try {
                ejbTimerServiceImpl.create();
                ejbTimerServiceImpl.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start EJBTimerService", e);
            }
        }
        return ejbTimerService;
    }

    public static class MBeanDelegate
    implements EJBTimerService {
        private EJBTimerService ejbTimerService;

        public MBeanDelegate(MBeanServer server) {
            try {
                this.ejbTimerService = (EJBTimerService)MBeanProxy.get(EJBTimerService.class, (ObjectName)EJBTimerService.OBJECT_NAME, (MBeanServer)server);
            }
            catch (MBeanProxyCreationException e) {
                throw new IllegalStateException("Cannot create EJBTimerService proxy");
            }
        }

        public TimerService createTimerService(ObjectName containerId, Object instancePk, Container container) throws IllegalStateException {
            try {
                TimerService timerService = this.ejbTimerService.createTimerService(containerId, instancePk, container);
                return timerService;
            }
            catch (Exception e) {
                log.error((Object)"Cannot createTimerService", (Throwable)e);
                return null;
            }
        }

        public TimerService createTimerService(ObjectName containerId, Object instancePk, TimedObjectInvoker invoker) throws IllegalStateException {
            try {
                TimerService timerService = this.ejbTimerService.createTimerService(containerId, instancePk, invoker);
                return timerService;
            }
            catch (Exception e) {
                log.error((Object)"Cannot createTimerService", (Throwable)e);
                return null;
            }
        }

        public TimerService getTimerService(ObjectName containerId, Object instancePk) throws IllegalStateException {
            try {
                TimerService timerService = this.ejbTimerService.getTimerService(containerId, instancePk);
                return timerService;
            }
            catch (Exception e) {
                log.error((Object)"Cannot getTimerService", (Throwable)e);
                return null;
            }
        }

        public void removeTimerService(ObjectName containerId, Object instancePk) throws IllegalStateException {
            try {
                this.ejbTimerService.removeTimerService(containerId, instancePk);
            }
            catch (Exception e) {
                log.error((Object)"Cannot removeTimerService", (Throwable)e);
            }
        }

        public void removeTimerService(ObjectName containerId, boolean keepState) throws IllegalStateException {
            try {
                this.ejbTimerService.removeTimerService(containerId, keepState);
            }
            catch (Exception e) {
                log.error((Object)"Cannot removeTimerService", (Throwable)e);
            }
        }

        public void restoreTimers(ObjectName containerId, ClassLoader loader) throws IllegalStateException {
            try {
                this.ejbTimerService.restoreTimers(containerId, loader);
            }
            catch (Exception e) {
                log.error((Object)"Cannot restoreTimer", (Throwable)e);
            }
        }
    }
}

