/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jms;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.ejb.EJBMetaData;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.plugins.jms.DLQHandler;
import org.jboss.ejb.plugins.jms.JMSContainerInvokerMBean;
import org.jboss.ejb.plugins.jms.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class JMSContainerInvoker
extends ServiceMBeanSupport
implements EJBProxyFactory,
JMSContainerInvokerMBean {
    private static final Logger log = Logger.getLogger(JMSContainerInvoker.class);
    private static final String CONNECTING_NOTIFICATION = "org.jboss.ejb.plugins.jms.CONNECTING";
    private static final String CONNECTED_NOTIFICATION = "org.jboss.ejb.plugins.jms.CONNECTED";
    private static final String DISCONNECTING_NOTIFICATION = "org.jboss.ejb.plugins.jms.DISCONNECTING";
    private static final String DISCONNECTED_NOTIFICATION = "org.jboss.ejb.plugins.jms.DISCONNECTED";
    private static final String FAILURE_NOTIFICATION = "org.jboss.ejb.plugins.jms.FAILURE";
    protected static Method ON_MESSAGE;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected boolean optimize;
    protected int maxMessagesNr = 1;
    protected int minPoolSize = 1;
    protected long keepAlive = 30000L;
    protected int maxPoolSize = 15;
    protected long reconnectInterval = 10000L;
    protected boolean useDLQ = false;
    protected String providerAdapterJNDI;
    protected String serverSessionPoolFactoryJNDI;
    protected int acknowledgeMode;
    protected boolean isContainerManagedTx;
    protected boolean isNotSupportedTx;
    protected Container container;
    protected Connection connection;
    protected ConnectionConsumer connectionConsumer;
    protected TransactionManager tm;
    protected ServerSessionPool pool;
    protected ExceptionListenerImpl exListener;
    protected DLQHandler dlqHandler;
    protected Element dlqConfig;
    protected InvokerProxyBindingMetaData invokerMetaData;
    protected String invokerBinding;
    protected boolean deliveryActive = true;
    protected boolean createJBossMQDestination = true;

    public void setInvokerMetaData(InvokerProxyBindingMetaData imd) {
        this.invokerMetaData = imd;
    }

    public void setInvokerBinding(String binding) {
        this.invokerBinding = binding;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveMillis() {
        return this.keepAlive;
    }

    public void setKeepAliveMillis(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getMaxMessages() {
        return this.maxMessagesNr;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessagesNr = maxMessages;
    }

    public MessageDrivenMetaData getMetaData() {
        MessageDrivenMetaData config = (MessageDrivenMetaData)this.container.getBeanMetaData();
        return config;
    }

    public boolean getDeliveryActive() {
        return this.deliveryActive;
    }

    public boolean getCreateJBossMQDestination() {
        return this.createJBossMQDestination;
    }

    public void startDelivery() throws Exception {
        if (this.getState() != 3) {
            throw new IllegalStateException("The MDB is not started");
        }
        if (this.deliveryActive) {
            return;
        }
        this.deliveryActive = true;
        this.startService();
    }

    public void stopDelivery() throws Exception {
        if (this.getState() != 3) {
            throw new IllegalStateException("The MDB is not started");
        }
        if (!this.deliveryActive) {
            return;
        }
        this.deliveryActive = false;
        this.stopService();
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean isIdentical(Container container, Invocation mi) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEJBHome() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaData() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Collection getEntityCollection(Collection ids) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEntityEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatefulSessionEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatelessSessionEJBObject() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void importXml(Element element) throws Exception {
        try {
            if ("false".equalsIgnoreCase(MetaData.getElementContent(MetaData.getUniqueChild(element, "CreateJBossMQDestination")))) {
                this.createJBossMQDestination = false;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String maxMessages = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaxMessages"));
            this.maxMessagesNr = Integer.parseInt(maxMessages);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String minSize = MetaData.getElementContent(MetaData.getUniqueChild(element, "MinimumSize"));
            this.minPoolSize = Integer.parseInt(minSize);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String maxSize = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaximumSize"));
            this.maxPoolSize = Integer.parseInt(maxSize);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String keepAliveMillis = MetaData.getElementContent(MetaData.getUniqueChild(element, "KeepAliveMillis"));
            this.keepAlive = Integer.parseInt(keepAliveMillis);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Element mdbConfig = MetaData.getUniqueChild(element, "MDBConfig");
        try {
            String reconnect = MetaData.getElementContent(MetaData.getUniqueChild(mdbConfig, "ReconnectIntervalSec"));
            this.reconnectInterval = Long.parseLong(reconnect) * 1000L;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if ("false".equalsIgnoreCase(MetaData.getElementContent(MetaData.getUniqueChild(mdbConfig, "DeliveryActive")))) {
                this.deliveryActive = false;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Element dlqEl = MetaData.getOptionalChild(mdbConfig, "DLQConfig");
        if (dlqEl != null) {
            this.dlqConfig = (Element)dlqEl.cloneNode(true);
            this.useDLQ = true;
        } else {
            this.useDLQ = false;
        }
        this.providerAdapterJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "JMSProviderAdapterJNDI"));
        this.serverSessionPoolFactoryJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "ServerSessionPoolFactoryJNDI"));
        if (!this.providerAdapterJNDI.startsWith("java:/")) {
            this.providerAdapterJNDI = "java:/" + this.providerAdapterJNDI;
        }
        if (!this.serverSessionPoolFactoryJNDI.startsWith("java:/")) {
            this.serverSessionPoolFactoryJNDI = "java:/" + this.serverSessionPoolFactoryJNDI;
        }
    }

    protected void createService() throws Exception {
        this.importXml(this.invokerMetaData.getProxyFactoryConfig());
        this.exListener = new ExceptionListenerImpl(this);
    }

    protected void innerStartDelivery() throws Exception {
        String link;
        byte txType;
        if (!this.deliveryActive) {
            log.debug((Object)"Delivery is disabled");
            return;
        }
        this.sendNotification(CONNECTING_NOTIFICATION, null);
        log.debug((Object)"Initializing");
        JMSProviderAdapter adapter = this.getJMSProviderAdapter();
        log.debug((Object)("Provider adapter: " + adapter));
        if (this.useDLQ) {
            this.dlqHandler = new DLQHandler(adapter, this);
            this.dlqHandler.importXml(this.dlqConfig);
            this.dlqHandler.create();
        }
        this.tm = this.container.getTransactionManager();
        MessageDrivenMetaData config = this.getMetaData();
        String messageSelector = config.getMessageSelector();
        String activationConfig = this.getActivationConfigProperty("messageSelector");
        if (activationConfig != null) {
            messageSelector = activationConfig;
        }
        String destinationType = config.getDestinationType();
        activationConfig = this.getActivationConfigProperty("destinationType");
        if (activationConfig != null) {
            destinationType = activationConfig;
        }
        this.isContainerManagedTx = config.isContainerManagedTx();
        this.acknowledgeMode = config.getAcknowledgeMode();
        activationConfig = this.getActivationConfigProperty("acknowledgeMode");
        if (activationConfig != null) {
            this.acknowledgeMode = activationConfig.equals("DUPS_OK_ACKNOWLEDGE") ? 3 : 1;
        }
        this.isNotSupportedTx = (txType = config.getMethodTransactionType("onMessage", new Class[]{Message.class}, InvocationType.LOCAL)) == 0;
        String destinationJNDI = config.getDestinationJndiName();
        activationConfig = this.getActivationConfigProperty("destination");
        if (activationConfig != null) {
            destinationJNDI = activationConfig;
        }
        if (destinationJNDI == null && (link = config.getDestinationLink()) != null && (link = link.trim()).length() > 0) {
            MessageDestinationMetaData destinationMetaData = this.container.getMessageDestination(link);
            if (destinationMetaData == null) {
                log.warn((Object)("Unresolved message-destination-link '" + link + "' no message-destination in ejb-jar.xml"));
            } else {
                String jndiName = destinationMetaData.getJNDIName();
                if (jndiName == null) {
                    log.warn((Object)("The message-destination '" + link + "' has no jndi-name in jboss.xml"));
                } else {
                    destinationJNDI = jndiName;
                }
            }
        }
        String user = config.getUser();
        String password = config.getPasswd();
        Context context = adapter.getInitialContext();
        log.debug((Object)("context: " + context));
        if (context == null) {
            throw new RuntimeException("Failed to get the root context");
        }
        String jndiSuffix = this.parseJndiSuffix(destinationJNDI, config.getEjbName());
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        if (destinationType == null) {
            log.warn((Object)"No message-driven-destination given; using; guessing type");
            destinationType = this.getDestinationType(context, destinationJNDI);
        }
        if (DEFAULT_DESTINATION_TYPE.equals(destinationType)) {
            log.debug((Object)("Got destination type Topic for " + config.getEjbName()));
            Object factory = context.lookup(adapter.getTopicFactoryRef());
            TopicConnection tConnection = null;
            try {
                tConnection = ConnectionFactoryHelper.createTopicConnection(factory, user, password);
                this.connection = tConnection;
            }
            catch (ClassCastException e) {
                throw new DeploymentException("Expected a TopicConnection check your provider adaptor: " + adapter.getTopicFactoryRef());
            }
            try {
                String clientId = config.getClientId();
                activationConfig = this.getActivationConfigProperty("clientID");
                if (activationConfig != null) {
                    clientId = activationConfig;
                }
                log.debug((Object)("Using client id: " + clientId));
                if (clientId != null && clientId.length() > 0) {
                    this.connection.setClientID(clientId);
                }
                Topic topic = null;
                try {
                    if (destinationJNDI != null) {
                        topic = (Topic)context.lookup(destinationJNDI);
                    } else if (!this.createJBossMQDestination) {
                        throw new DeploymentException("Unable to determine destination for '" + this.container.getBeanMetaData().getEjbName() + "' use destination-jndi-name in jboss.xml, an activation config property or a message-destination-link");
                    }
                }
                catch (NamingException e) {
                    if (!this.createJBossMQDestination) {
                        throw new DeploymentException("Could not find the topic destination-jndi-name=" + destinationJNDI, (Throwable)e);
                    }
                    log.warn((Object)("Could not find the topic destination-jndi-name=" + destinationJNDI), (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new DeploymentException("Expected a Topic destination-jndi-name=" + destinationJNDI, (Throwable)e);
                }
                if (topic == null) {
                    topic = (Topic)this.createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
                }
                this.pool = this.createSessionPool((Destination)topic, (Connection)tConnection, this.minPoolSize, this.maxPoolSize, this.keepAlive, true, this.acknowledgeMode, new MessageListenerImpl(this));
                byte subscriptionDurablity = config.getSubscriptionDurability();
                activationConfig = this.getActivationConfigProperty("subscriptionDurability");
                if (activationConfig != null) {
                    subscriptionDurablity = activationConfig.equals("Durable") ? (byte)0 : 1;
                }
                if (subscriptionDurablity != 0) {
                    this.connectionConsumer = tConnection.createConnectionConsumer(topic, messageSelector, this.pool, this.maxMessagesNr);
                } else {
                    String durableName = config.getSubscriptionId();
                    activationConfig = this.getActivationConfigProperty("subscriptionName");
                    if (activationConfig != null) {
                        durableName = activationConfig;
                    }
                    this.connectionConsumer = tConnection.createDurableConnectionConsumer(topic, durableName, messageSelector, this.pool, this.maxMessagesNr);
                }
                log.debug((Object)"Topic connectionConsumer set up");
            }
            catch (Throwable t) {
                try {
                    tConnection.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                DeploymentException.rethrowAsDeploymentException((String)"Error during topic setup", (Throwable)t);
            }
        } else if ("javax.jms.Queue".equals(destinationType)) {
            log.debug((Object)("Got destination type Queue for " + config.getEjbName()));
            Object qFactory = context.lookup(adapter.getQueueFactoryRef());
            QueueConnection qConnection = null;
            try {
                qConnection = ConnectionFactoryHelper.createQueueConnection(qFactory, user, password);
                this.connection = qConnection;
            }
            catch (ClassCastException e) {
                throw new DeploymentException("Expected a QueueConnection check your provider adaptor: " + adapter.getQueueFactoryRef());
            }
            try {
                String clientId = config.getClientId();
                activationConfig = this.getActivationConfigProperty("clientID");
                if (activationConfig != null) {
                    clientId = activationConfig;
                }
                log.debug((Object)("Using client id: " + clientId));
                if (clientId != null && clientId.length() > 0) {
                    this.connection.setClientID(clientId);
                }
                Queue queue = null;
                try {
                    if (destinationJNDI != null) {
                        queue = (Queue)context.lookup(destinationJNDI);
                    } else if (!this.createJBossMQDestination) {
                        throw new DeploymentException("Unable to determine destination for '" + this.container.getBeanMetaData().getEjbName() + "' use destination-jndi-name in jboss.xml, an activation config property or a message-destination-link");
                    }
                }
                catch (NamingException e) {
                    if (!this.createJBossMQDestination) {
                        throw new DeploymentException("Could not find the queue destination-jndi-name=" + destinationJNDI, (Throwable)e);
                    }
                    log.warn((Object)("Could not find the queue destination-jndi-name=" + destinationJNDI));
                }
                catch (ClassCastException e) {
                    throw new DeploymentException("Expected a Queue destination-jndi-name=" + destinationJNDI);
                }
                if (queue == null) {
                    queue = (Queue)this.createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
                }
                this.pool = this.createSessionPool((Destination)queue, (Connection)qConnection, this.minPoolSize, this.maxPoolSize, this.keepAlive, true, this.acknowledgeMode, new MessageListenerImpl(this));
                log.debug((Object)("Server session pool: " + this.pool));
                this.connectionConsumer = qConnection.createConnectionConsumer(queue, messageSelector, this.pool, this.maxMessagesNr);
                log.debug((Object)("Connection consumer: " + this.connectionConsumer));
            }
            catch (Throwable t) {
                try {
                    qConnection.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                DeploymentException.rethrowAsDeploymentException((String)"Error during queue setup", (Throwable)t);
            }
        } else {
            throw new DeploymentException("Unknown destination-type " + destinationType);
        }
        log.debug((Object)("Initialized with config " + this.toString()));
        context.close();
        if (this.dlqHandler != null) {
            this.dlqHandler.start();
        }
        if (this.connection != null) {
            this.connection.setExceptionListener((ExceptionListener)this.exListener);
            this.connection.start();
        }
        this.sendNotification(CONNECTED_NOTIFICATION, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        try {
            this.innerStartDelivery();
        }
        catch (Throwable t) {
            this.exListener.handleFailure(t);
            return;
        }
        finally {
            SecurityActions.clear();
        }
    }

    protected void stopService() throws Exception {
        if (this.exListener != null) {
            this.exListener.stop();
        }
        this.innerStopDelivery();
    }

    protected void innerStopDelivery() {
        log.debug((Object)"innerStop");
        this.sendNotification(DISCONNECTING_NOTIFICATION, null);
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
                log.debug((Object)"unset exception listener");
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Could not set ExceptionListener to null", t);
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
                log.debug((Object)"connection stopped");
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Could not stop JMS connection", t);
        }
        try {
            if (this.dlqHandler != null) {
                this.dlqHandler.stop();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Failed to stop the dlq handler", t);
        }
        try {
            if (this.connectionConsumer != null) {
                this.connectionConsumer.close();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Failed to close connection consumer", t);
        }
        this.connectionConsumer = null;
        try {
            if (this.pool instanceof StdServerSessionPool) {
                StdServerSessionPool p = (StdServerSessionPool)this.pool;
                p.clear();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Failed to clear session pool", t);
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable t) {
                log.trace((Object)"Failed to close connection", t);
            }
        }
        this.connection = null;
        try {
            if (this.dlqHandler != null) {
                this.dlqHandler.destroy();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Failed to close the dlq handler", t);
        }
        this.dlqHandler = null;
        this.sendNotification(DISCONNECTED_NOTIFICATION, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) throws Exception {
        Invocation invocation = new Invocation(id, m, args, tx, identity, credential);
        invocation.setType(InvocationType.LOCAL);
        ClassLoader oldCL = TCLAction.UTIL.getContextClassLoader();
        TCLAction.UTIL.setContextClassLoader(this.container.getClassLoader());
        try {
            Object object = this.container.invoke(invocation);
            return object;
        }
        finally {
            TCLAction.UTIL.setContextClassLoader(oldCL);
        }
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                log.debug((Object)"Could not do heristic lookup of destination ", (Throwable)ex);
            }
        }
        if (destType == null) {
            log.warn((Object)"Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        InitialContext context = new InitialContext();
        try {
            log.debug((Object)("Looking up provider adapter: " + this.providerAdapterJNDI));
            JMSProviderAdapter jMSProviderAdapter = (JMSProviderAdapter)context.lookup(this.providerAdapterJNDI);
            return jMSProviderAdapter;
        }
        finally {
            context.close();
        }
    }

    protected Destination createDestination(Class type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            String methodName;
            log.warn((Object)("destination not found: " + jndiName + " reason: " + e));
            log.warn((Object)("creating a new temporary destination: " + jndiName));
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (type == Topic.class) {
                methodName = "createTopic";
            } else if (type == Queue.class) {
                methodName = "createQueue";
            } else {
                throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
            }
            server.invoke(new ObjectName("jboss.mq:service=DestinationManager"), methodName, new Object[]{jndiSuffix}, new String[]{"java.lang.String"});
            return (Destination)ctx.lookup(jndiName);
        }
    }

    protected String getActivationConfigProperty(String property) {
        MessageDrivenMetaData mdmd = this.getMetaData();
        ActivationConfigPropertyMetaData acpmd = mdmd.getActivationConfigProperty(property);
        if (acpmd != null) {
            return acpmd.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSessionPool createSessionPool(Destination destination, Connection connection, int minSession, int maxSession, long keepAlive, boolean isTransacted, int ack, MessageListener listener) throws NamingException, JMSException {
        ServerSessionPool pool;
        InitialContext context = new InitialContext();
        try {
            log.debug((Object)("looking up session pool factory: " + this.serverSessionPoolFactoryJNDI));
            ServerSessionPoolFactory factory = (ServerSessionPoolFactory)context.lookup(this.serverSessionPoolFactoryJNDI);
            pool = factory.getServerSessionPool(destination, connection, minSession, maxSession, keepAlive, isTransacted, ack, !this.isContainerManagedTx || this.isNotSupportedTx, listener);
        }
        finally {
            context.close();
        }
        return pool;
    }

    protected void sendNotification(String event, Object userData) {
        Notification notif = new Notification(event, this.getServiceName(), this.getNextNotificationSequenceNumber());
        notif.setUserData(userData);
        this.sendNotification(notif);
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    public String toString() {
        MessageDrivenMetaData metaData = this.getMetaData();
        String destinationJNDI = metaData.getDestinationJndiName();
        return super.toString() + "{ maxMessagesNr=" + this.maxMessagesNr + ", maxPoolSize=" + this.maxPoolSize + ", reconnectInterval=" + this.reconnectInterval + ", providerAdapterJNDI=" + this.providerAdapterJNDI + ", serverSessionPoolFactoryJNDI=" + this.serverSessionPoolFactoryJNDI + ", acknowledgeMode=" + this.acknowledgeMode + ", isContainerManagedTx=" + this.isContainerManagedTx + ", isNotSupportedTx=" + this.isNotSupportedTx + ", useDLQ=" + this.useDLQ + ", dlqHandler=" + (Object)((Object)this.dlqHandler) + ", destinationJNDI=" + destinationJNDI + " }";
    }

    static {
        try {
            Class<MessageListener> type = MessageListener.class;
            Class<Message> arg = Message.class;
            ON_MESSAGE = type.getMethod("onMessage", arg);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    class ExceptionListenerImpl
    implements ExceptionListener {
        Object lock = new Object();
        JMSContainerInvoker invoker;
        Thread currentThread;
        boolean notStopped = true;

        ExceptionListenerImpl(JMSContainerInvoker invoker) {
            this.invoker = invoker;
        }

        public void onException(JMSException ex) {
            this.handleFailure(ex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFailure(Throwable t) {
            MessageDrivenMetaData metaData = this.invoker.getMetaData();
            log.warn((Object)("JMS provider failure detected for " + metaData.getEjbName()), t);
            String name = "JMSContainerInvoker(" + metaData.getEjbName() + ") Reconnect";
            Object object = this.lock;
            synchronized (object) {
                if (this.currentThread != null) {
                    log.debug((Object)("Already a reconnect thread: " + this.currentThread + " for " + metaData.getEjbName()));
                    return;
                }
                ExceptionListenerRunnable runnable = new ExceptionListenerRunnable(t);
                this.currentThread = new Thread((Runnable)runnable, name);
                try {
                    this.currentThread.setDaemon(true);
                    this.currentThread.start();
                }
                catch (RuntimeException rethrow) {
                    this.currentThread = null;
                    throw rethrow;
                }
                catch (Error rethrow) {
                    this.currentThread = null;
                    throw rethrow;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Object object = this.lock;
            synchronized (object) {
                log.debug((Object)("Stop requested for recovery thread: " + this.currentThread));
                this.notStopped = false;
                if (this.currentThread != null) {
                    this.currentThread.interrupt();
                    log.debug((Object)("Recovery thread interrupted: " + this.currentThread));
                }
            }
        }

        class ExceptionListenerRunnable
        implements Runnable {
            Throwable failure;

            public ExceptionListenerRunnable(Throwable failure) {
                this.failure = failure;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MessageDrivenMetaData metaData = ExceptionListenerImpl.this.invoker.getMetaData();
                try {
                    boolean tryIt = true;
                    while (tryIt && ExceptionListenerImpl.this.notStopped) {
                        try {
                            ExceptionListenerImpl.this.invoker.innerStopDelivery();
                        }
                        catch (Throwable t) {
                            log.error((Object)("Unhandled error stopping connection for " + metaData.getEjbName()), t);
                        }
                        JMSContainerInvoker.this.sendNotification(JMSContainerInvoker.FAILURE_NOTIFICATION, this.failure);
                        log.info((Object)("Waiting for reconnect internal " + JMSContainerInvoker.this.reconnectInterval + "ms for " + metaData.getEjbName()));
                        try {
                            Thread.sleep(JMSContainerInvoker.this.reconnectInterval);
                        }
                        catch (InterruptedException ie) {
                            tryIt = false;
                            Object object = ExceptionListenerImpl.this.lock;
                            synchronized (object) {
                                ExceptionListenerImpl.this.currentThread = null;
                            }
                            return;
                        }
                        try {
                            log.info((Object)("Trying to reconnect to JMS provider for " + metaData.getEjbName()));
                            ExceptionListenerImpl.this.invoker.innerStartDelivery();
                            tryIt = false;
                            log.info((Object)("Reconnected to JMS provider for " + metaData.getEjbName()));
                        }
                        catch (Throwable t) {
                            log.error((Object)("Reconnect failed: JMS provider failure detected for " + metaData.getEjbName()), t);
                        }
                    }
                }
                finally {
                    Object object = ExceptionListenerImpl.this.lock;
                    synchronized (object) {
                        ExceptionListenerImpl.this.currentThread = null;
                    }
                }
            }
        }
    }

    class MessageListenerImpl
    implements MessageListener {
        JMSContainerInvoker invoker;

        MessageListenerImpl(JMSContainerInvoker invoker) {
            this.invoker = invoker;
        }

        public void onMessage(Message message) {
            String id;
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing message: " + message));
            }
            try {
                id = message.getJMSMessageID();
            }
            catch (JMSException e) {
                id = "JMSContainerInvoker";
            }
            try {
                Transaction tx = JMSContainerInvoker.this.tm.getTransaction();
                if (JMSContainerInvoker.this.useDLQ && message.getJMSRedelivered() && JMSContainerInvoker.this.dlqHandler.handleRedeliveredMessage(message, tx)) {
                    return;
                }
                this.invoker.invoke(id, ON_MESSAGE, new Object[]{message}, tx, null, null);
            }
            catch (Exception e) {
                log.error((Object)"Exception in JMSCI message listener", (Throwable)e);
            }
        }
    }
}

