/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.schema;

import java.sql.SQLException;
import javax.ejb.EJBException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.RelationTable;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Table;
import org.jboss.tm.TransactionLocal;

public class Schema {
    private EntityTable[] entityTables;
    private RelationTable[] relationTables;
    private TransactionLocal localViews = new TransactionLocal(){

        protected Object initialValue() {
            Transaction tx = this.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("An operation requires an active transaction!");
            }
            Views views = new Views(tx);
            SchemaSynchronization sync = new SchemaSynchronization(views);
            try {
                tx.registerSynchronization((Synchronization)sync);
            }
            catch (RollbackException e) {
                throw new EJBException("Transaction already marked to roll back: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (SystemException e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to register transaction synchronization: " + e.getMessage());
            }
            return views;
        }
    };

    public EntityTable createEntityTable(JDBCEntityMetaData metadata, JDBCEntityBridge2 entity) throws DeploymentException {
        EntityTable table;
        if (this.entityTables == null) {
            this.entityTables = new EntityTable[1];
        } else {
            EntityTable[] tmp = this.entityTables;
            this.entityTables = new EntityTable[tmp.length + 1];
            System.arraycopy(tmp, 0, this.entityTables, 0, tmp.length);
        }
        this.entityTables[this.entityTables.length - 1] = table = new EntityTable(metadata, entity, this, this.entityTables.length - 1);
        return table;
    }

    public RelationTable createRelationTable(JDBCCMRFieldBridge2 leftField, JDBCCMRFieldBridge2 rightField) throws DeploymentException {
        RelationTable table;
        if (this.relationTables == null) {
            this.relationTables = new RelationTable[1];
        } else {
            RelationTable[] tmp = this.relationTables;
            this.relationTables = new RelationTable[tmp.length + 1];
            System.arraycopy(tmp, 0, this.relationTables, 0, tmp.length);
        }
        this.relationTables[this.relationTables.length - 1] = table = new RelationTable(leftField, rightField, this, this.relationTables.length - 1);
        return table;
    }

    public Table.View getView(EntityTable table) {
        Views views = (Views)this.localViews.get();
        Table.View view = views.entityViews[table.getTableId()];
        if (view == null) {
            views.entityViews[table.getTableId()] = view = table.createView(views.tx);
        }
        return view;
    }

    public Table.View getView(RelationTable table) {
        Views views = (Views)this.localViews.get();
        Table.View view = views.relationViews[table.getTableId()];
        if (view == null) {
            views.relationViews[table.getTableId()] = view = table.createView(views.tx);
        }
        return view;
    }

    public void flush() {
        Table.View view;
        int i;
        Views views = (Views)this.localViews.get();
        Table.View[] relationViews = views.relationViews;
        if (relationViews != null) {
            for (int i2 = 0; i2 < relationViews.length; ++i2) {
                Table.View view2 = relationViews[i2];
                if (view2 == null) continue;
                try {
                    view2.flushDeleted(views);
                    continue;
                }
                catch (SQLException e) {
                    throw new EJBException("Failed to delete many-to-many relationships: " + e.getMessage(), (Exception)e);
                }
            }
        }
        Table.View[] entityViews = views.entityViews;
        for (i = 0; i < entityViews.length; ++i) {
            view = entityViews[i];
            if (view == null) continue;
            try {
                view.flushDeleted(views);
                continue;
            }
            catch (SQLException e) {
                throw new EJBException("Failed to delete instances: " + e.getMessage(), (Exception)e);
            }
        }
        for (i = 0; i < entityViews.length; ++i) {
            view = entityViews[i];
            if (view == null) continue;
            try {
                view.flushCreated(views);
                continue;
            }
            catch (SQLException e) {
                throw new EJBException("Failed to create instances: " + e.getMessage(), (Exception)e);
            }
        }
        for (i = 0; i < entityViews.length; ++i) {
            view = entityViews[i];
            if (view == null) continue;
            try {
                view.flushUpdated();
                continue;
            }
            catch (SQLException e) {
                throw new EJBException("Failed to update instances: " + e.getMessage(), (Exception)e);
            }
        }
        if (relationViews != null) {
            for (i = 0; i < relationViews.length; ++i) {
                view = relationViews[i];
                if (view == null) continue;
                try {
                    view.flushCreated(views);
                    continue;
                }
                catch (SQLException e) {
                    throw new EJBException("Failed to create many-to-many relationships: " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private class SchemaSynchronization
    implements Synchronization {
        private final Views views;

        public SchemaSynchronization(Views views) {
            this.views = views;
        }

        public void beforeCompletion() {
            Schema.this.flush();
            for (int i = 0; i < this.views.entityViews.length; ++i) {
                Table.View view = this.views.entityViews[i];
                if (view == null) continue;
                view.beforeCompletion();
            }
        }

        public void afterCompletion(int status) {
            if (status == 1 || status == 4 || status == 9) {
                for (int i = 0; i < this.views.entityViews.length; ++i) {
                    Table.View view = this.views.entityViews[i];
                    if (view == null) continue;
                    view.rolledback();
                }
            } else {
                for (int i = 0; i < this.views.entityViews.length; ++i) {
                    Table.View view = this.views.entityViews[i];
                    if (view == null) continue;
                    view.committed();
                }
            }
        }
    }

    public class Views {
        public final Transaction tx;
        public final Table.View[] entityViews;
        public final Table.View[] relationViews;

        public Views(Transaction tx) {
            this.tx = tx;
            this.entityViews = new Table.View[Schema.this.entityTables.length];
            this.relationViews = Schema.this.relationTables == null ? null : new Table.View[Schema.this.relationTables.length];
        }
    }
}

