/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.GetTCLAction;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCAuditMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaDataFactory;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.QueryMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.Element;

public final class JDBCEntityMetaData {
    private final JDBCApplicationMetaData jdbcApplication;
    private final String dataSourceName;
    private final String datasourceMappingName;
    private final JDBCTypeMappingMetaData datasourceMapping;
    private final String entityName;
    private final String abstractSchemaName;
    private final Class entityClass;
    private final Class homeClass;
    private final Class remoteClass;
    private final Class localHomeClass;
    private final Class localClass;
    private final boolean isCMP1x;
    private final String tableName;
    private final boolean createTable;
    private final boolean removeTable;
    private final boolean alterTable;
    private final ArrayList tablePostCreateCmd;
    private final boolean rowLocking;
    private final boolean readOnly;
    private final int readTimeOut;
    private final boolean primaryKeyConstraint;
    private final Class primaryKeyClass;
    private final String primaryKeyFieldName;
    private final Map cmpFieldsByName = new HashMap();
    private final List cmpFields = new ArrayList();
    private final Map loadGroups = new HashMap();
    private final String eagerLoadGroup;
    private final List lazyLoadGroups = new ArrayList();
    private final Map queries = new HashMap();
    private final JDBCQueryMetaDataFactory queryFactory;
    private final JDBCReadAheadMetaData readAhead;
    private final boolean cleanReadAheadOnLoad;
    private final int listCacheMax;
    private final int fetchSize;
    private final JDBCEntityCommandMetaData entityCommand;
    private final JDBCOptimisticLockingMetaData optimisticLocking;
    private final JDBCAuditMetaData audit;
    private final Class qlCompiler;
    private final boolean throwRuntimeExceptions;

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, EntityMetaData entity) throws DeploymentException {
        this.jdbcApplication = jdbcApplication;
        this.entityName = entity.getEjbName();
        this.listCacheMax = 1000;
        this.fetchSize = 0;
        try {
            this.entityClass = this.getClassLoader().loadClass(entity.getEjbClass());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("entity class not found: " + this.entityName);
        }
        try {
            this.primaryKeyClass = this.getClassLoader().loadClass(entity.getPrimaryKeyClass());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("could not load primary key class: " + entity.getPrimaryKeyClass());
        }
        this.isCMP1x = entity.isCMP1x();
        this.abstractSchemaName = this.isCMP1x ? (entity.getAbstractSchemaName() == null ? this.entityName : entity.getAbstractSchemaName()) : entity.getAbstractSchemaName();
        this.primaryKeyFieldName = entity.getPrimKeyField();
        String home = entity.getHome();
        if (home != null) {
            try {
                this.homeClass = this.getClassLoader().loadClass(home);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("home class not found: " + home);
            }
            try {
                this.remoteClass = this.getClassLoader().loadClass(entity.getRemote());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("remote class not found: " + entity.getRemote());
            }
        }
        this.homeClass = null;
        this.remoteClass = null;
        String localHome = entity.getLocalHome();
        if (localHome != null) {
            try {
                this.localHomeClass = this.getClassLoader().loadClass(localHome);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("local home class not found: " + localHome);
            }
            try {
                this.localClass = this.getClassLoader().loadClass(entity.getLocal());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("local class not found: " + entity.getLocal());
            }
        }
        if (home == null) {
            throw new DeploymentException("Entity must have atleast a home or local home: " + this.entityName);
        }
        this.localHomeClass = null;
        this.localClass = null;
        this.tableName = this.entityName.replace('.', '_');
        this.dataSourceName = null;
        this.datasourceMappingName = null;
        this.datasourceMapping = null;
        this.createTable = false;
        this.removeTable = false;
        this.alterTable = false;
        this.rowLocking = false;
        this.primaryKeyConstraint = false;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.tablePostCreateCmd = null;
        this.qlCompiler = null;
        this.throwRuntimeExceptions = false;
        ArrayList<String> nonPkFieldNames = new ArrayList<String>();
        Iterator i = entity.getCMPFields();
        while (i.hasNext()) {
            String cmpFieldName = (String)i.next();
            JDBCCMPFieldMetaData cmpField = new JDBCCMPFieldMetaData(this, cmpFieldName);
            this.cmpFields.add(cmpField);
            this.cmpFieldsByName.put(cmpFieldName, cmpField);
            if (cmpField.isPrimaryKeyMember()) continue;
            nonPkFieldNames.add(cmpFieldName);
        }
        if (this.primaryKeyClass == Object.class) {
            JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this);
            this.cmpFields.add(upkField);
            this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
        }
        this.eagerLoadGroup = "*";
        this.queryFactory = new JDBCQueryMetaDataFactory(this);
        Iterator queriesIterator = entity.getQueries();
        while (queriesIterator.hasNext()) {
            QueryMetaData queryData = (QueryMetaData)queriesIterator.next();
            Map newQueries = this.queryFactory.createJDBCQueryMetaData(queryData);
            this.queries.putAll(newQueries);
        }
        this.readAhead = JDBCReadAheadMetaData.DEFAULT;
        this.cleanReadAheadOnLoad = false;
        this.entityCommand = null;
        this.optimisticLocking = null;
        this.audit = null;
    }

    public JDBCEntityMetaData(JDBCApplicationMetaData jdbcApplication, Element element, JDBCEntityMetaData defaultValues) throws DeploymentException {
        Element upkElement;
        String compiler;
        String fetchSizeStr;
        String readOnlyStr;
        String tableStr;
        this.jdbcApplication = jdbcApplication;
        this.entityName = defaultValues.getName();
        this.entityClass = defaultValues.getEntityClass();
        this.primaryKeyClass = defaultValues.getPrimaryKeyClass();
        this.isCMP1x = defaultValues.isCMP1x;
        this.primaryKeyFieldName = defaultValues.getPrimaryKeyFieldName();
        this.homeClass = defaultValues.getHomeClass();
        this.remoteClass = defaultValues.getRemoteClass();
        this.localHomeClass = defaultValues.getLocalHomeClass();
        this.localClass = defaultValues.getLocalClass();
        this.queryFactory = new JDBCQueryMetaDataFactory(this);
        this.abstractSchemaName = this.isCMP1x ? (defaultValues.getAbstractSchemaName() == null ? this.entityName : defaultValues.getAbstractSchemaName()) : defaultValues.getAbstractSchemaName();
        String dataSourceNameString = MetaData.getOptionalChildContent(element, "datasource");
        this.dataSourceName = dataSourceNameString != null ? dataSourceNameString : defaultValues.getDataSourceName();
        String datasourceMappingString = MetaData.getOptionalChildContent(element, "datasource-mapping");
        if (datasourceMappingString != null) {
            this.datasourceMappingName = datasourceMappingString;
            this.datasourceMapping = jdbcApplication.getTypeMappingByName(datasourceMappingString);
            if (this.datasourceMapping == null) {
                throw new DeploymentException("Error in jbosscmp-jdbc.xml : datasource-mapping " + datasourceMappingString + " not found");
            }
        } else if (defaultValues.datasourceMappingName != null && defaultValues.datasourceMapping != null) {
            this.datasourceMappingName = null;
            this.datasourceMapping = defaultValues.datasourceMapping;
        } else {
            this.datasourceMappingName = null;
            this.datasourceMapping = JDBCEntityMetaData.obtainTypeMappingFromLibrary(this.dataSourceName);
        }
        this.tableName = (tableStr = MetaData.getOptionalChildContent(element, "table-name")) != null ? tableStr : defaultValues.getDefaultTableName();
        String createStr = MetaData.getOptionalChildContent(element, "create-table");
        this.createTable = createStr != null ? Boolean.valueOf(createStr).booleanValue() : defaultValues.getCreateTable();
        String removeStr = MetaData.getOptionalChildContent(element, "remove-table");
        this.removeTable = removeStr != null ? Boolean.valueOf(removeStr).booleanValue() : defaultValues.getRemoveTable();
        String alterStr = MetaData.getOptionalChildContent(element, "alter-table");
        this.alterTable = alterStr != null ? Boolean.valueOf(alterStr).booleanValue() : defaultValues.getAlterTable();
        Element posttc = MetaData.getOptionalChild(element, "post-table-create");
        if (posttc != null) {
            Iterator it = MetaData.getChildrenByTagName(posttc, "sql-statement");
            this.tablePostCreateCmd = new ArrayList();
            while (it.hasNext()) {
                Element etmp = (Element)it.next();
                this.tablePostCreateCmd.add(MetaData.getElementContent(etmp));
            }
        } else {
            this.tablePostCreateCmd = defaultValues.getDefaultTablePostCreateCmd();
        }
        this.readOnly = (readOnlyStr = MetaData.getOptionalChildContent(element, "read-only")) != null ? Boolean.valueOf(readOnlyStr).booleanValue() : defaultValues.isReadOnly();
        String readTimeOutStr = MetaData.getOptionalChildContent(element, "read-time-out");
        if (readTimeOutStr != null) {
            try {
                this.readTimeOut = Integer.parseInt(readTimeOutStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutStr + "': " + e);
            }
        } else {
            this.readTimeOut = defaultValues.getReadTimeOut();
        }
        String sForUpStr = MetaData.getOptionalChildContent(element, "row-locking");
        this.rowLocking = sForUpStr != null ? !this.isReadOnly() && Boolean.valueOf(sForUpStr) != false : defaultValues.hasRowLocking();
        String pkStr = MetaData.getOptionalChildContent(element, "pk-constraint");
        this.primaryKeyConstraint = pkStr != null ? Boolean.valueOf(pkStr).booleanValue() : defaultValues.hasPrimaryKeyConstraint();
        String listCacheMaxStr = MetaData.getOptionalChildContent(element, "list-cache-max");
        if (listCacheMaxStr != null) {
            try {
                this.listCacheMax = Integer.parseInt(listCacheMaxStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid number format in read-ahead list-cache-max '" + listCacheMaxStr + "': " + e);
            }
            if (this.listCacheMax < 0) {
                throw new DeploymentException("Negative value for read ahead list-cache-max '" + listCacheMaxStr + "'.");
            }
        } else {
            this.listCacheMax = defaultValues.getListCacheMax();
        }
        if ((fetchSizeStr = MetaData.getOptionalChildContent(element, "fetch-size")) != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid number format in fetch-size '" + fetchSizeStr + "': " + e);
            }
            if (this.fetchSize < 0) {
                throw new DeploymentException("Negative value for fetch size fetch-size '" + fetchSizeStr + "'.");
            }
        } else {
            this.fetchSize = defaultValues.getFetchSize();
        }
        if ((compiler = MetaData.getOptionalChildContent(element, "ql-compiler")) == null) {
            this.qlCompiler = defaultValues.qlCompiler;
        } else {
            try {
                this.qlCompiler = GetTCLAction.getContextClassLoader().loadClass(compiler);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Failed to load compiler implementation: " + compiler);
            }
        }
        String throwRuntimeExceptionsStr = MetaData.getOptionalChildContent(element, "throw-runtime-exceptions");
        this.throwRuntimeExceptions = throwRuntimeExceptionsStr != null ? Boolean.valueOf(throwRuntimeExceptionsStr).booleanValue() : defaultValues.getThrowRuntimeExceptions();
        Iterator cmpFieldIterator = defaultValues.cmpFields.iterator();
        while (cmpFieldIterator.hasNext()) {
            JDBCCMPFieldMetaData cmpField = new JDBCCMPFieldMetaData(this, (JDBCCMPFieldMetaData)cmpFieldIterator.next());
            this.cmpFields.add(cmpField);
            this.cmpFieldsByName.put(cmpField.getFieldName(), cmpField);
        }
        Iterator i = MetaData.getChildrenByTagName(element, "cmp-field");
        while (i.hasNext()) {
            Element cmpFieldElement = (Element)i.next();
            String fieldName = MetaData.getUniqueChildContent(cmpFieldElement, "field-name");
            JDBCCMPFieldMetaData oldCMPField = (JDBCCMPFieldMetaData)this.cmpFieldsByName.get(fieldName);
            if (oldCMPField == null) {
                throw new DeploymentException("CMP field not found : fieldName=" + fieldName);
            }
            JDBCCMPFieldMetaData cmpFieldMetaData = new JDBCCMPFieldMetaData(this, cmpFieldElement, oldCMPField);
            this.cmpFieldsByName.put(fieldName, cmpFieldMetaData);
            int index = this.cmpFields.indexOf(oldCMPField);
            this.cmpFields.remove(oldCMPField);
            this.cmpFields.add(index, cmpFieldMetaData);
        }
        if (this.primaryKeyClass == Object.class && (upkElement = MetaData.getOptionalChild(element, "unknown-pk")) != null) {
            JDBCCMPFieldMetaData oldUpkField = null;
            for (JDBCCMPFieldMetaData cmpField : this.cmpFields) {
                if (!cmpField.isUnknownPkField()) continue;
                oldUpkField = cmpField;
                break;
            }
            if (oldUpkField == null) {
                oldUpkField = new JDBCCMPFieldMetaData(this);
            }
            JDBCCMPFieldMetaData upkField = new JDBCCMPFieldMetaData(this, upkElement, oldUpkField);
            this.cmpFieldsByName.remove(oldUpkField.getFieldName());
            this.cmpFieldsByName.put(upkField.getFieldName(), upkField);
            int oldUpkFieldInd = this.cmpFields.indexOf(oldUpkField);
            this.cmpFields.remove(oldUpkField);
            this.cmpFields.add(oldUpkFieldInd, upkField);
        }
        this.loadGroups.putAll(defaultValues.loadGroups);
        this.loadLoadGroupsXml(element);
        Element eagerLoadGroupElement = MetaData.getOptionalChild(element, "eager-load-group");
        if (eagerLoadGroupElement != null) {
            String eagerLoadGroupTmp = MetaData.getElementContent(eagerLoadGroupElement);
            if (eagerLoadGroupTmp != null && eagerLoadGroupTmp.trim().length() == 0) {
                eagerLoadGroupTmp = null;
            }
            if (eagerLoadGroupTmp != null && !eagerLoadGroupTmp.equals("*") && !this.loadGroups.containsKey(eagerLoadGroupTmp)) {
                throw new DeploymentException("Eager load group not found: eager-load-group=" + eagerLoadGroupTmp);
            }
            this.eagerLoadGroup = eagerLoadGroupTmp;
        } else {
            this.eagerLoadGroup = defaultValues.getEagerLoadGroup();
        }
        this.lazyLoadGroups.addAll(defaultValues.lazyLoadGroups);
        this.loadLazyLoadGroupsXml(element);
        Element readAheadElement = MetaData.getOptionalChild(element, "read-ahead");
        this.readAhead = readAheadElement != null ? new JDBCReadAheadMetaData(readAheadElement, defaultValues.getReadAhead()) : defaultValues.readAhead;
        String value = MetaData.getOptionalChildContent(element, "clean-read-ahead-on-load");
        if ("true".equalsIgnoreCase(value)) {
            this.cleanReadAheadOnLoad = true;
        } else if ("false".equalsIgnoreCase(value)) {
            this.cleanReadAheadOnLoad = false;
        } else if (value == null) {
            this.cleanReadAheadOnLoad = defaultValues.cleanReadAheadOnLoad;
        } else {
            throw new DeploymentException("Failed to deploy " + this.entityName + ": allowed values for clean-read-ahead-on-load are true and false but got " + value);
        }
        Element optimisticLockingEl = MetaData.getOptionalChild(element, "optimistic-locking");
        this.optimisticLocking = optimisticLockingEl != null ? new JDBCOptimisticLockingMetaData(this, optimisticLockingEl) : defaultValues.getOptimisticLocking();
        Element auditElement = MetaData.getOptionalChild(element, "audit");
        this.audit = auditElement != null ? new JDBCAuditMetaData(this, auditElement) : defaultValues.getAudit();
        Iterator queriesIterator = defaultValues.queries.values().iterator();
        while (queriesIterator.hasNext()) {
            JDBCQueryMetaData query = JDBCQueryMetaDataFactory.createJDBCQueryMetaData((JDBCQueryMetaData)queriesIterator.next(), this.readAhead, this.qlCompiler);
            this.queries.put(query.getMethod(), query);
        }
        queriesIterator = MetaData.getChildrenByTagName(element, "query");
        while (queriesIterator.hasNext()) {
            Element queryElement = (Element)queriesIterator.next();
            Map newQueries = this.queryFactory.createJDBCQueryMetaData(queryElement, defaultValues.queries, this.readAhead);
            this.queries.putAll(newQueries);
        }
        Element entityCommandEl = MetaData.getOptionalChild(element, "entity-command");
        if (entityCommandEl != null) {
            String entityCommandName = entityCommandEl.getAttribute("name");
            JDBCEntityCommandMetaData defaultEntityCommand = defaultValues.getEntityCommand();
            if (defaultEntityCommand == null || !entityCommandName.equals(defaultEntityCommand.getCommandName())) {
                defaultEntityCommand = jdbcApplication.getEntityCommandByName(entityCommandName);
            }
            this.entityCommand = defaultEntityCommand != null ? new JDBCEntityCommandMetaData(entityCommandEl, defaultEntityCommand) : new JDBCEntityCommandMetaData(entityCommandEl);
        } else {
            this.entityCommand = defaultValues.getEntityCommand();
        }
    }

    private void loadLoadGroupsXml(Element element) throws DeploymentException {
        Element loadGroupsElement = MetaData.getOptionalChild(element, "load-groups");
        if (loadGroupsElement == null) {
            return;
        }
        if (this.isCMP1x) {
            throw new DeploymentException("load-groups are only allowed for CMP 2.x");
        }
        Iterator groups = MetaData.getChildrenByTagName(loadGroupsElement, "load-group");
        while (groups.hasNext()) {
            Element groupElement = (Element)groups.next();
            String loadGroupName = MetaData.getUniqueChildContent(groupElement, "load-group-name");
            if (this.loadGroups.containsKey(loadGroupName)) {
                throw new DeploymentException("Load group already defined:  load-group-name=" + loadGroupName);
            }
            if (loadGroupName.equals("*")) {
                throw new DeploymentException("The * load group is automatically defined and can't be overriden");
            }
            ArrayList<String> group = new ArrayList<String>();
            Iterator fields = MetaData.getChildrenByTagName(groupElement, "field-name");
            while (fields.hasNext()) {
                String fieldName = MetaData.getElementContent((Element)fields.next());
                JDBCCMPFieldMetaData field = this.getCMPFieldByName(fieldName);
                if (field != null && field.isPrimaryKeyMember()) {
                    throw new DeploymentException("Primary key fields can not be a member of a load group:  load-group-name=" + loadGroupName + " field-name=" + fieldName);
                }
                group.add(fieldName);
            }
            this.loadGroups.put(loadGroupName, Collections.unmodifiableList(group));
        }
    }

    private void loadLazyLoadGroupsXml(Element element) throws DeploymentException {
        Element lazyLoadGroupsElement = MetaData.getOptionalChild(element, "lazy-load-groups");
        if (lazyLoadGroupsElement == null) {
            return;
        }
        if (this.isCMP1x) {
            throw new DeploymentException("lazy-load-groups is only allowed for CMP 2.x");
        }
        Iterator loadGroupNames = MetaData.getChildrenByTagName(lazyLoadGroupsElement, "load-group-name");
        while (loadGroupNames.hasNext()) {
            String loadGroupName = MetaData.getElementContent((Element)loadGroupNames.next());
            if (!loadGroupName.equals("*") && !this.loadGroups.containsKey(loadGroupName)) {
                throw new DeploymentException("Lazy load group not found: load-group-name=" + loadGroupName);
            }
            this.lazyLoadGroups.add(loadGroupName);
        }
    }

    public JDBCApplicationMetaData getJDBCApplication() {
        return this.jdbcApplication;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public JDBCTypeMappingMetaData getTypeMapping() throws DeploymentException {
        if (this.datasourceMapping == null) {
            throw new DeploymentException("type-mapping is not initialized: " + this.dataSourceName + " was not deployed or type-mapping was not configured.");
        }
        return this.datasourceMapping;
    }

    public String getName() {
        return this.entityName;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public ClassLoader getClassLoader() {
        return this.jdbcApplication.getClassLoader();
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public Class getHomeClass() {
        return this.homeClass;
    }

    public Class getRemoteClass() {
        return this.remoteClass;
    }

    public Class getLocalHomeClass() {
        return this.localHomeClass;
    }

    public Class getLocalClass() {
        return this.localClass;
    }

    public boolean isCMP1x() {
        return this.isCMP1x;
    }

    public List getCMPFields() {
        return Collections.unmodifiableList(this.cmpFields);
    }

    public String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    public List getLazyLoadGroups() {
        return Collections.unmodifiableList(this.lazyLoadGroups);
    }

    public Map getLoadGroups() {
        return Collections.unmodifiableMap(this.loadGroups);
    }

    public List getLoadGroup(String name) throws DeploymentException {
        List group = (List)this.loadGroups.get(name);
        if (group == null) {
            throw new DeploymentException("Unknown load group: name=" + name);
        }
        return group;
    }

    public JDBCOptimisticLockingMetaData getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public JDBCAuditMetaData getAudit() {
        return this.audit;
    }

    public JDBCCMPFieldMetaData getCMPFieldByName(String name) {
        return (JDBCCMPFieldMetaData)this.cmpFieldsByName.get(name);
    }

    public String getDefaultTableName() {
        return this.tableName;
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public boolean getRemoveTable() {
        return this.removeTable;
    }

    public boolean getAlterTable() {
        return this.alterTable;
    }

    public ArrayList getDefaultTablePostCreateCmd() {
        return this.tablePostCreateCmd;
    }

    public boolean hasPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public boolean hasRowLocking() {
        return this.rowLocking;
    }

    public int getListCacheMax() {
        return this.listCacheMax;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Collection getQueries() {
        return Collections.unmodifiableCollection(this.queries.values());
    }

    public JDBCQueryMetaData getQueryMetaDataForMethod(Method method) {
        return (JDBCQueryMetaData)this.queries.get(method);
    }

    public Collection getRelationshipRoles() {
        return this.jdbcApplication.getRolesForEntity(this.entityName);
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public JDBCEntityCommandMetaData getEntityCommand() {
        return this.entityCommand;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public String getPrimaryKeyFieldName() {
        return this.primaryKeyFieldName;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Class getQLCompiler() {
        return this.qlCompiler;
    }

    public boolean isThrowRuntimeExceptions() {
        return this.throwRuntimeExceptions;
    }

    public boolean getThrowRuntimeExceptions() {
        return this.throwRuntimeExceptions;
    }

    public boolean isCleanReadAheadOnLoad() {
        return this.cleanReadAheadOnLoad;
    }

    public static JDBCTypeMappingMetaData obtainTypeMappingFromLibrary(String dataSourceName) throws DeploymentException {
        ObjectName metadataService;
        String datasource;
        JDBCTypeMappingMetaData typeMapping = null;
        if (dataSourceName.startsWith("java:")) {
            datasource = dataSourceName.substring("java:".length());
            if (datasource.startsWith("/")) {
                datasource = datasource.substring(1);
            }
        } else {
            datasource = dataSourceName;
        }
        String str = "jboss.jdbc:service=metadata,datasource=" + datasource;
        try {
            metadataService = new ObjectName(str);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Failed to create ObjectName for datasource metadata MBean: " + str, (Throwable)e);
        }
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (server.isRegistered(metadataService)) {
                typeMapping = (JDBCTypeMappingMetaData)server.getAttribute(metadataService, "TypeMappingMetaData");
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to obtain type-mapping metadata from the metadata library MBean: " + e.getMessage(), (Throwable)e);
        }
        return typeMapping;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCEntityMetaData) {
            JDBCEntityMetaData entity = (JDBCEntityMetaData)o;
            return this.entityName.equals(entity.entityName) && this.jdbcApplication.equals(entity.jdbcApplication);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.jdbcApplication.hashCode();
        result = 37 * result + this.entityName.hashCode();
        return result;
    }

    public String toString() {
        return "[JDBCEntityMetaData : entityName=" + this.entityName + "]";
    }
}

