/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCPostgreSQLCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence;
    private String sequenceSQL;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.sequence = entityCommand.getAttribute("sequence");
        if (this.sequence == null) {
            this.sequence = this.entity.getQualifiedTableName() + '_' + SQLUtil.getColumnNamesClause(this.pkField, new StringBuffer(20)) + "_seq";
        }
        this.sequenceSQL = "SELECT currval('" + this.sequence + "')";
        if (this.debug) {
            this.log.debug((Object)("SEQUENCE SQL is :" + this.sequenceSQL));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeInsert(int index, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement s = null;
        ResultSet rs = null;
        try {
            Connection c;
            if (this.trace) {
                this.log.trace((Object)("Executing SQL :" + this.sequenceSQL));
            }
            if (!(rs = (s = (c = ps.getConnection()).createStatement()).executeQuery(this.sequenceSQL)).next()) {
                throw new EJBException("sequence sql returned an empty ResultSet");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException("Error extracting generated keys", e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(s);
        return rows;
    }
}

