/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCOracleSequenceCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence_name;
    private int pkIndex;
    private int jdbcType;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.sequence_name = entityCommand.getAttribute("sequence_name");
        if (this.sequence_name == null) {
            throw new DeploymentException("sequence_name attribute must be specified inside <entity-command>");
        }
    }

    protected void initInsertSQL() {
        this.pkIndex = 1 + this.insertFields.length;
        this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
        StringBuffer sql = new StringBuffer();
        sql.append("{call INSERT INTO ").append(this.entity.getTableName());
        sql.append(" (");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" VALUES (");
        String sequence_name_inst = JDBCOracleSequenceCreateCommand.replaceTable(this.sequence_name, this.entity.getTableName());
        sql.append(sequence_name_inst + ".NEXTVAL, ");
        SQLUtil.getValuesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" RETURNING ");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug((Object)("Insert Entity SQL: " + this.insertSQL));
        }
    }

    protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException {
        return c.prepareCall(sql);
    }

    protected int executeInsert(PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        CallableStatement cs = (CallableStatement)ps;
        cs.registerOutParameter(this.pkIndex, this.jdbcType);
        cs.execute();
        Object pk = JDBCUtil.getParameter(this.log, cs, this.pkIndex, this.jdbcType, this.pkField.getFieldType());
        this.pkField.setInstanceValue(ctx, pk);
        return 1;
    }

    private static String replaceTable(String in, String table) {
        int pos = in.indexOf("%%t");
        if (pos == -1) {
            return in;
        }
        String first = in.substring(0, pos);
        String last = in.substring(pos + 3);
        return first + table + last;
    }
}

