/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.ejbql.ASTAbs;
import org.jboss.ejb.plugins.cmp.ejbql.ASTAbstractSchema;
import org.jboss.ejb.plugins.cmp.ejbql.ASTAnd;
import org.jboss.ejb.plugins.cmp.ejbql.ASTApproximateNumericLiteral;
import org.jboss.ejb.plugins.cmp.ejbql.ASTArithmeticComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTArithmeticParenthetical;
import org.jboss.ejb.plugins.cmp.ejbql.ASTAvg;
import org.jboss.ejb.plugins.cmp.ejbql.ASTBetween;
import org.jboss.ejb.plugins.cmp.ejbql.ASTBooleanComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTBooleanLiteral;
import org.jboss.ejb.plugins.cmp.ejbql.ASTCollectionMemberDeclaration;
import org.jboss.ejb.plugins.cmp.ejbql.ASTConcat;
import org.jboss.ejb.plugins.cmp.ejbql.ASTConditionalParenthetical;
import org.jboss.ejb.plugins.cmp.ejbql.ASTCount;
import org.jboss.ejb.plugins.cmp.ejbql.ASTDatetimeComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTEJBQL;
import org.jboss.ejb.plugins.cmp.ejbql.ASTEntityComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTExactNumericLiteral;
import org.jboss.ejb.plugins.cmp.ejbql.ASTFrom;
import org.jboss.ejb.plugins.cmp.ejbql.ASTIdentifier;
import org.jboss.ejb.plugins.cmp.ejbql.ASTIn;
import org.jboss.ejb.plugins.cmp.ejbql.ASTIsEmpty;
import org.jboss.ejb.plugins.cmp.ejbql.ASTLCase;
import org.jboss.ejb.plugins.cmp.ejbql.ASTLength;
import org.jboss.ejb.plugins.cmp.ejbql.ASTLike;
import org.jboss.ejb.plugins.cmp.ejbql.ASTLimitOffset;
import org.jboss.ejb.plugins.cmp.ejbql.ASTLocate;
import org.jboss.ejb.plugins.cmp.ejbql.ASTMax;
import org.jboss.ejb.plugins.cmp.ejbql.ASTMemberOf;
import org.jboss.ejb.plugins.cmp.ejbql.ASTMin;
import org.jboss.ejb.plugins.cmp.ejbql.ASTMod;
import org.jboss.ejb.plugins.cmp.ejbql.ASTMultDiv;
import org.jboss.ejb.plugins.cmp.ejbql.ASTNegation;
import org.jboss.ejb.plugins.cmp.ejbql.ASTNot;
import org.jboss.ejb.plugins.cmp.ejbql.ASTNullComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTOr;
import org.jboss.ejb.plugins.cmp.ejbql.ASTOrderBy;
import org.jboss.ejb.plugins.cmp.ejbql.ASTOrderByPath;
import org.jboss.ejb.plugins.cmp.ejbql.ASTParameter;
import org.jboss.ejb.plugins.cmp.ejbql.ASTPath;
import org.jboss.ejb.plugins.cmp.ejbql.ASTPlusMinus;
import org.jboss.ejb.plugins.cmp.ejbql.ASTRangeVariableDeclaration;
import org.jboss.ejb.plugins.cmp.ejbql.ASTSelect;
import org.jboss.ejb.plugins.cmp.ejbql.ASTSqrt;
import org.jboss.ejb.plugins.cmp.ejbql.ASTStringComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTStringLiteral;
import org.jboss.ejb.plugins.cmp.ejbql.ASTStringParenthetical;
import org.jboss.ejb.plugins.cmp.ejbql.ASTSubstring;
import org.jboss.ejb.plugins.cmp.ejbql.ASTSum;
import org.jboss.ejb.plugins.cmp.ejbql.ASTUCase;
import org.jboss.ejb.plugins.cmp.ejbql.ASTValueClassComparison;
import org.jboss.ejb.plugins.cmp.ejbql.ASTWhere;
import org.jboss.ejb.plugins.cmp.ejbql.ASTWhereConditionalTerm;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.ejbql.EJBQLParser;
import org.jboss.ejb.plugins.cmp.ejbql.EJBQLTypes;
import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParser;
import org.jboss.ejb.plugins.cmp.ejbql.JBossQLParserVisitor;
import org.jboss.ejb.plugins.cmp.ejbql.Node;
import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
import org.jboss.ejb.plugins.cmp.ejbql.SimpleNode;
import org.jboss.ejb.plugins.cmp.jdbc.AliasManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.logging.Logger;

public final class EJBQLToSQL92Compiler
implements QLCompiler,
JBossQLParserVisitor {
    private static final Logger log = Logger.getLogger(EJBQLToSQL92Compiler.class);
    private final Catalog catalog;
    private Class returnType;
    private Class[] parameterTypes;
    private JDBCReadAheadMetaData readAhead;
    private AliasManager aliasManager;
    private Map joinPaths = new HashMap();
    private Map identifierToTable = new HashMap();
    private Set joinedAliases = new HashSet();
    private JDBCTypeMappingMetaData typeMapping;
    private JDBCTypeFactory typeFactory;
    private boolean forceDistinct;
    private String sql;
    private int offsetParam;
    private int offsetValue;
    private int limitParam;
    private int limitValue;
    private JDBCEntityPersistenceStore selectManager;
    private Object selectObject;
    private List inputParameters = new ArrayList();
    private List leftJoinCMRList = new ArrayList();
    private StringBuffer onFindCMRJoin;
    private boolean countCompositePk;

    public EJBQLToSQL92Compiler(Catalog catalog) {
        this.catalog = catalog;
    }

    public void compileEJBQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        EJBQLParser parser = new EJBQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    public void compileJBossQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        JBossQLParser parser = new JBossQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ejbql: " + ejbql));
                log.trace((Object)("sql: " + this.sql));
            }
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    public String getSQL() {
        return this.sql;
    }

    public int getOffsetValue() {
        return this.offsetValue;
    }

    public int getOffsetParam() {
        return this.offsetParam;
    }

    public int getLimitValue() {
        return this.limitValue;
    }

    public int getLimitParam() {
        return this.limitParam;
    }

    public boolean isSelectEntity() {
        return this.selectObject instanceof JDBCAbstractEntityBridge;
    }

    public JDBCAbstractEntityBridge getSelectEntity() {
        return (JDBCAbstractEntityBridge)this.selectObject;
    }

    public boolean isSelectField() {
        boolean result;
        if (this.selectObject instanceof JDBCFieldBridge) {
            JDBCFieldBridge field = (JDBCFieldBridge)this.selectObject;
            result = field.isCMPField();
        } else {
            result = false;
        }
        return result;
    }

    public JDBCFieldBridge getSelectField() {
        return (JDBCFieldBridge)this.selectObject;
    }

    public SelectFunction getSelectFunction() {
        return (SelectFunction)this.selectObject;
    }

    public EntityPersistenceStore getStoreManager() {
        return this.selectManager;
    }

    public List getInputParameters() {
        return this.inputParameters;
    }

    public List getLeftJoinCMRList() {
        return this.leftJoinCMRList;
    }

    public Object visit(SimpleNode node, Object data) {
        throw new RuntimeException("Internal error: Found unknown node type in EJB-QL abstract syntax tree: node=" + node);
    }

    public Object visit(ASTEJBQL node, Object data) {
        Node selectNode = node.jjtGetChild(0);
        Node fromNode = node.jjtGetChild(1);
        StringBuffer selectClause = new StringBuffer(50);
        selectNode.jjtAccept(this, selectClause);
        StringBuffer whereClause = null;
        StringBuffer orderByClause = null;
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Node childNode = node.jjtGetChild(i);
            if (childNode instanceof ASTWhere) {
                whereClause = new StringBuffer(20);
                childNode.jjtAccept(this, whereClause);
                continue;
            }
            if (childNode instanceof ASTOrderBy) {
                orderByClause = new StringBuffer();
                childNode.jjtAccept(this, orderByClause);
                continue;
            }
            if (!(childNode instanceof ASTLimitOffset)) continue;
            childNode.jjtAccept(this, null);
        }
        StringBuffer fromClause = new StringBuffer(30);
        fromNode.jjtAccept(this, fromClause);
        Iterator iter = this.identifierToTable.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String identifier = (String)entry.getKey();
            String table = (String)entry.getValue();
            String alias = this.aliasManager.getAlias(identifier);
            fromClause.append(table).append(' ').append(alias);
            this.join(alias, fromClause);
            if (!iter.hasNext()) continue;
            fromClause.append(", ");
        }
        StringBuffer sql = (StringBuffer)data;
        if (this.selectManager.getMetaData().hasRowLocking() && !(this.selectObject instanceof SelectFunction)) {
            JDBCFunctionMappingMetaData rowLockingTemplate = this.typeMapping.getRowLockingTemplate();
            if (rowLockingTemplate == null) {
                throw new IllegalStateException("Row locking template is not defined for given mapping: " + this.typeMapping.getName());
            }
            boolean distinct = ((ASTSelect)selectNode).distinct || this.returnType == Set.class || this.forceDistinct;
            Object[] args = new Object[]{distinct ? "DISTINCT " + selectClause : selectClause.toString(), fromClause, whereClause == null || whereClause.length() == 0 ? null : whereClause, orderByClause == null || orderByClause.length() == 0 ? null : orderByClause};
            rowLockingTemplate.getFunctionSql(args, sql);
        } else {
            sql.append("SELECT ");
            if (((ASTSelect)selectNode).distinct || this.returnType == Set.class || this.forceDistinct) {
                sql.append("DISTINCT ");
            }
            sql.append(selectClause).append(" FROM ").append(fromClause);
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            if (orderByClause != null && orderByClause.length() > 0) {
                sql.append(" ORDER BY ").append(orderByClause);
            }
        }
        if (this.countCompositePk) {
            sql.insert(0, "SELECT COUNT(*) FROM (").append(") t_count");
        }
        return data;
    }

    public Object visit(ASTOrderBy node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(", ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTOrderByPath node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.ascending) {
            buf.append(" ASC");
        } else {
            buf.append(" DESC");
        }
        return data;
    }

    public Object visit(ASTLimitOffset node, Object data) {
        Class parameterType;
        SimpleNode param;
        int child = 0;
        if (node.hasOffset) {
            Node offsetNode;
            if ((offsetNode = node.jjtGetChild(child++)) instanceof ASTParameter) {
                param = (ASTParameter)offsetNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw new IllegalStateException("OFFSET parameter must be an int");
                }
                this.offsetParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)offsetNode;
                this.offsetValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        if (node.hasLimit) {
            Node limitNode = node.jjtGetChild(child);
            if (limitNode instanceof ASTParameter) {
                param = (ASTParameter)limitNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw new IllegalStateException("LIMIT parameter must be an int");
                }
                this.limitParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)limitNode;
                this.limitValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        return data;
    }

    public Object visit(ASTSelect select, Object data) {
        StringBuffer sql = (StringBuffer)data;
        Node child0 = select.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            ASTPath path = (ASTPath)child0;
            if (path.isCMPField()) {
                JDBCFieldBridge selectField = (JDBCFieldBridge)((Object)path.getCMPField());
                this.selectManager = selectField.getManager();
                this.selectObject = selectField;
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addInnerJoinPath(path);
                String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                SQLUtil.getColumnNamesClause(selectField, alias, sql);
            } else {
                JDBCAbstractEntityBridge selectEntity = (JDBCAbstractEntityBridge)path.getEntity();
                this.selectManager = selectEntity.getManager();
                this.selectObject = selectEntity;
                this.setTypeFactory(selectEntity.getManager().getJDBCTypeFactory());
                String alias = this.aliasManager.getAlias(path.getPath());
                SQLUtil.getColumnNamesClause(selectEntity.getTableFields(), alias, sql);
                this.addLeftJoinPath(path);
            }
        } else {
            ASTPath path = this.getPathFromChildren(child0);
            if (path == null) {
                throw new IllegalStateException("The function in SELECT clause does not contain a path expression.");
            }
            if (path.isCMPField()) {
                JDBCFieldBridge selectField = (JDBCFieldBridge)((Object)path.getCMPField());
                this.selectManager = selectField.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
            } else if (path.isCMRField()) {
                JDBCFieldBridge cmrField = (JDBCFieldBridge)((Object)path.getCMRField());
                this.selectManager = cmrField.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addLeftJoinPath(path);
            } else {
                JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)path.getEntity();
                this.selectManager = entity.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addLeftJoinPath(path);
            }
            this.selectObject = child0;
            child0.jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTWhere node, Object data) {
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTOr node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(" OR ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTWhereConditionalTerm node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTAnd node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(" AND ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTNot node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(" NOT ");
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTConditionalParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    public Object visit(ASTBetween node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" BETWEEN ");
        node.jjtGetChild(1).jjtAccept(this, data);
        buf.append(" AND ");
        node.jjtGetChild(2).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTIn node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" IN ").append('(');
        node.jjtGetChild(1).jjtAccept(this, data);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            buf.append(", ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        buf.append(')');
        return data;
    }

    public Object visit(ASTLike node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" LIKE ");
        node.jjtGetChild(1).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            buf.append(" ESCAPE ");
            node.jjtGetChild(2).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTNullComparison node, Object data) {
        StringBuffer sql = (StringBuffer)data;
        Node child0 = node.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            ASTPath path = (ASTPath)child0;
            this.addLeftJoinPath(path);
            JDBCFieldBridge field = (JDBCFieldBridge)path.getField();
            if (field instanceof JDBCAbstractCMRFieldBridge) {
                JDBCFieldBridge[] keyFields;
                String alias;
                JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)field;
                if (cmrField.hasForeignKey()) {
                    alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                    keyFields = cmrField.getForeignKeyFields();
                } else {
                    alias = this.aliasManager.getAlias(path.getPath());
                    keyFields = cmrField.getMetaData().getRelationMetaData().isTableMappingStyle() ? cmrField.getRelatedCMRField().getEntity().getPrimaryKeyFields() : cmrField.getRelatedCMRField().getForeignKeyFields();
                }
                SQLUtil.getIsNullClause(node.not, keyFields, alias, sql);
            } else {
                String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                SQLUtil.getIsNullClause(node.not, field, alias, sql);
            }
        } else if (child0 instanceof ASTParameter) {
            ASTParameter param = (ASTParameter)child0;
            Class type = this.getParameterType(param.number);
            QueryParameter queryParam = new QueryParameter(param.number - 1, false, null, null, this.typeFactory.getJDBCTypeForJavaType(type));
            this.inputParameters.add(queryParam);
            sql.append("? IS ");
            if (node.not) {
                sql.append(" NOT ");
            }
            sql.append("NULL");
        } else {
            throw new IllegalStateException("Unexpected node in IS NULL clause: " + node);
        }
        return data;
    }

    public Object visit(ASTIsEmpty node, Object data) {
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        if (!path.isCMRField()) {
            throw new IllegalStateException("IS EMPTY can be applied only to collection valued CMR field.");
        }
        this.addLeftJoinPath(path);
        StringBuffer sql = (StringBuffer)data;
        JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField();
        JDBCAbstractEntityBridge relatedEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
        String alias = this.aliasManager.getAlias(path.getPath());
        SQLUtil.getIsNullClause(node.not, relatedEntity.getPrimaryKeyFields(), alias, sql);
        return data;
    }

    public Object visit(ASTMemberOf node, Object data) {
        Node member = node.jjtGetChild(0);
        ASTPath colPath = (ASTPath)node.jjtGetChild(1);
        JDBCAbstractEntityBridge colEntity = (JDBCAbstractEntityBridge)colPath.getEntity();
        StringBuffer sql = (StringBuffer)data;
        if (node.not) {
            sql.append(" NOT ");
        }
        sql.append("EXISTS ").append('(').append("SELECT ");
        if (member instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)member;
            this.verifyParameterEntityType(toParam.number, colEntity);
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, colEntity));
            String parentAlias = this.aliasManager.getAlias(colPath.getPath(0));
            String localParentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
            JDBCAbstractEntityBridge parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
            SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), localParentAlias, sql);
            sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(localParentAlias);
            this.innerJoinPath(colPath, sql);
            sql.append(" WHERE ");
            JDBCAbstractEntityBridge col0 = (JDBCAbstractEntityBridge)colPath.getEntity(0);
            SQLUtil.getSelfCompareWhereClause(col0.getPrimaryKeyFields(), parentAlias, localParentAlias, sql);
            sql.append(" AND ");
            String localColAlias = this.aliasManager.getAlias(colPath.getPath() + "_local");
            SQLUtil.getWhereClause(colEntity.getPrimaryKeyFields(), localColAlias, sql);
        } else {
            JDBCAbstractEntityBridge parentEntity;
            String parentAlias;
            ASTPath memberPath = (ASTPath)member;
            JDBCAbstractEntityBridge memberEntity = (JDBCAbstractEntityBridge)memberPath.getEntity();
            if (!memberEntity.equals(colEntity)) {
                throw new IllegalStateException("Member must be if the same type as the collection, got: member=" + memberEntity.getEntityName() + ", collection=" + colEntity.getEntityName());
            }
            String memberAlias = this.aliasManager.getAlias(memberPath.getPath());
            if (memberPath.size() > 1) {
                parentAlias = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
                parentEntity = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
                SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
                sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
                this.innerJoinPath(memberPath, sql);
                this.innerJoinPath(colPath, sql);
            } else if (colPath.size() > 1) {
                parentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
                parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
                SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
                sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
                this.innerJoinPath(colPath, sql);
            } else {
                throw new IllegalStateException("There should be collection valued path expression, not identification variable.");
            }
            sql.append(" WHERE ");
            JDBCAbstractEntityBridge member0 = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
            String colAliasLocal = this.aliasManager.getAlias(colPath.getPath() + "_local");
            if (memberPath.size() > 1) {
                String memberAliasLocal = this.aliasManager.getAlias(memberPath.getPath() + "_local");
                SQLUtil.getSelfCompareWhereClause(colEntity.getPrimaryKeyFields(), memberAliasLocal, colAliasLocal, sql);
                sql.append(" AND ");
                String member0Alias = this.aliasManager.getAlias(memberPath.getPath(0));
                String member0AliasLocal = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
                SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), member0Alias, member0AliasLocal, sql);
            } else {
                SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), memberAlias, colAliasLocal, sql);
            }
        }
        sql.append(')');
        return data;
    }

    private void innerJoinPath(ASTPath path, StringBuffer sql) {
        String parentAlias;
        if (path.size() < 2) {
            return;
        }
        String leftAlias = parentAlias = this.aliasManager.getAlias(path.getPath(0) + "_local");
        for (int i = 1; i < path.size(); ++i) {
            String curPath = path.getPath(i);
            String joinAlias = this.aliasManager.getAlias(curPath + "_local");
            JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
            JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
            JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
            String join = " INNER JOIN ";
            if (relation.isTableMappingStyle()) {
                String relTableAlias = this.aliasManager.getRelationTableAlias(curPath + "_local");
                sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
                sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
            } else {
                sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
            }
            leftAlias = joinAlias;
        }
    }

    public Object visit(ASTStringComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTBooleanComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 2) {
            buf.append(' ').append(node.opp).append(' ');
            node.jjtGetChild(1).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTDatetimeComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTValueClassComparison node, Object data) {
        throw new IllegalStateException("Value class comparison is not yet supported.");
    }

    public Object visit(ASTEntityComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Node arg0 = node.jjtGetChild(0);
        Node arg1 = node.jjtGetChild(1);
        if (node.opp.equals("<>")) {
            this.compareEntity(true, arg0, arg1, buf);
        } else {
            this.compareEntity(false, arg0, arg1, buf);
        }
        return data;
    }

    public Object visit(ASTArithmeticComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTPlusMinus node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(' ').append(node.opps.get(i - 1)).append(' ');
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTMultDiv node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(' ').append(node.opps.get(i - 1)).append(' ');
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTNegation node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('-');
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTArithmeticParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    public Object visit(ASTStringParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    public Object visit(ASTConcat node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("concat");
        Object[] args = this.childrenToStringArr(2, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTSubstring node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("substring");
        Object[] args = this.childrenToStringArr(3, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTUCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("ucase");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTLCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("lcase");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTLength node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("length");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTLocate node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("locate");
        Object[] args = new Object[]{node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString(), node.jjtGetChild(1).jjtAccept(this, new StringBuffer()).toString(), node.jjtGetNumChildren() == 3 ? node.jjtGetChild(2).jjtAccept(this, new StringBuffer()).toString() : "1"};
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTAbs node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("abs");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTSqrt node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("sqrt");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTMod node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = JDBCTypeMappingMetaData.MOD_FUNC;
        Object[] args = this.childrenToStringArr(2, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTAvg node, Object data) {
        node.setResultType(this.returnType);
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.AVG_FUNC.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTMax node, Object data) {
        node.setResultType(this.returnType);
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.MAX_FUNC.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTMin node, Object data) {
        node.setResultType(this.returnType);
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.MIN_FUNC.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTSum node, Object data) {
        node.setResultType(this.returnType);
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.SUM_FUNC.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTCount node, Object data) {
        Object[] args;
        StringBuffer buf = (StringBuffer)data;
        node.setResultType(this.returnType);
        ASTPath cntPath = (ASTPath)node.jjtGetChild(0);
        if (cntPath.isCMPField()) {
            args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        } else {
            JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)cntPath.getEntity();
            JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
            if (pkFields.length > 1) {
                this.countCompositePk = true;
                this.forceDistinct = node.distinct.length() > 0;
                this.addLeftJoinPath(cntPath);
                String alias = this.aliasManager.getAlias(cntPath.getPath());
                SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, buf);
                return buf;
            }
            String alias = this.aliasManager.getAlias(cntPath.getPath());
            StringBuffer keyColumn = new StringBuffer(20);
            SQLUtil.getColumnNamesClause(pkFields[0], alias, keyColumn);
            args = new Object[]{node.distinct, keyColumn.toString()};
        }
        JDBCTypeMappingMetaData.COUNT_FUNC.getFunctionSql(args, buf);
        return data;
    }

    public Object visit(ASTPath node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (!node.isCMPField()) {
            throw new IllegalStateException("Can only visit cmp valued path node. Should have been handled at a higher level.");
        }
        switch (node.type) {
            case -1: 
            case 5: 
            case 6: {
                throw new IllegalStateException("Can not visit multi-column path node. Should have been handled at a higher level.");
            }
        }
        this.addLeftJoinPath(node);
        JDBCFieldBridge cmpField = (JDBCFieldBridge)((Object)node.getCMPField());
        String alias = this.aliasManager.getAlias(node.getPath(node.size() - 2));
        SQLUtil.getColumnNamesClause(cmpField, alias, buf);
        return data;
    }

    public Object visit(ASTAbstractSchema node, Object data) {
        throw new IllegalStateException("Can not visit abstract schema node.  Should have been handled at a higher level.");
    }

    public Object visit(ASTIdentifier node, Object data) {
        throw new UnsupportedOperationException("Must not visit ASTIdentifier noe.");
    }

    public Object visit(ASTParameter node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Class type = this.getParameterType(node.number);
        int ejbqlType = EJBQLTypes.getEJBQLType(type);
        if (ejbqlType == 5 || ejbqlType == 6 || ejbqlType == -1) {
            throw new IllegalStateException("Can not visit multi-column parameter node. Should have been handled at a higher level.");
        }
        QueryParameter param = new QueryParameter(node.number - 1, false, null, null, this.typeFactory.getJDBCTypeForJavaType(type));
        this.inputParameters.add(param);
        buf.append('?');
        return data;
    }

    public Object visit(ASTExactNumericLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.literal);
        return data;
    }

    public Object visit(ASTApproximateNumericLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.literal);
        return data;
    }

    public Object visit(ASTStringLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.value);
        return data;
    }

    public Object visit(ASTBooleanLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (node.value) {
            buf.append(this.typeMapping.getTrueMapping());
        } else {
            buf.append(this.typeMapping.getFalseMapping());
        }
        return data;
    }

    public Object visit(ASTFrom from, Object data) {
        StringBuffer sql = (StringBuffer)data;
        from.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < from.jjtGetNumChildren(); ++i) {
            from.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTCollectionMemberDeclaration node, Object data) {
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        String alias = this.aliasManager.getAlias(id.identifier);
        this.aliasManager.addAlias(path.getPath(), alias);
        this.addInnerJoinPath(path);
        return data;
    }

    public Object visit(ASTRangeVariableDeclaration node, Object data) {
        ASTAbstractSchema schema = (ASTAbstractSchema)node.jjtGetChild(0);
        JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)schema.entity;
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        this.declareTable(id.identifier, entity.getQualifiedTableName());
        return data;
    }

    private void compareEntity(boolean not, Node fromNode, Node toNode, StringBuffer buf) {
        buf.append('(');
        if (not) {
            buf.append(" NOT ").append('(');
        }
        ASTPath fromPath = (ASTPath)fromNode;
        this.addLeftJoinPath(fromPath);
        String fromAlias = this.aliasManager.getAlias(fromPath.getPath());
        JDBCAbstractEntityBridge fromEntity = (JDBCAbstractEntityBridge)fromPath.getEntity();
        if (toNode instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)toNode;
            this.verifyParameterEntityType(toParam.number, fromEntity);
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromEntity));
            SQLUtil.getWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, buf);
        } else {
            ASTPath toPath = (ASTPath)toNode;
            this.addLeftJoinPath(toPath);
            String toAlias = this.aliasManager.getAlias(toPath.getPath());
            JDBCAbstractEntityBridge toEntity = (JDBCAbstractEntityBridge)toPath.getEntity();
            if (!fromEntity.equals(toEntity)) {
                throw new IllegalStateException("Only like types can be compared: from entity=" + fromEntity.getEntityName() + " to entity=" + toEntity.getEntityName());
            }
            SQLUtil.getSelfCompareWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, toAlias, buf);
        }
        if (not) {
            buf.append(')');
        }
        buf.append(')');
    }

    private void join(String alias, StringBuffer sql) {
        Map paths = (Map)this.joinPaths.get(alias);
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Iterator iter = paths.values().iterator();
        while (iter.hasNext()) {
            String leftAlias = alias;
            ASTPath path = (ASTPath)iter.next();
            for (int i = 1; i < path.size(); ++i) {
                if (!path.isCMRField(i)) continue;
                String curPath = path.getPath(i);
                String joinAlias = this.aliasManager.getAlias(curPath);
                if (this.joinedAliases.add(joinAlias)) {
                    String join;
                    JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
                    JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
                    JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
                    String string = join = path.innerJoin ? " INNER JOIN " : " LEFT OUTER JOIN ";
                    if (relation.isTableMappingStyle()) {
                        String relTableAlias = this.aliasManager.getRelationTableAlias(curPath);
                        sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
                        SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
                        sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                        SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
                    } else {
                        sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                        SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
                    }
                    this.join(joinAlias, sql);
                }
                leftAlias = joinAlias;
            }
        }
    }

    private void declareTable(String alias, String table) {
        this.identifierToTable.put(alias, table);
    }

    private void addLeftJoinPath(ASTPath path) {
        if (path.size() > 1 && path.isCMRField(1)) {
            ASTPath oldPath;
            String identifier = path.getPath(0);
            String alias = this.aliasManager.getAlias(identifier);
            HashMap<ASTPath, ASTPath> paths = (HashMap<ASTPath, ASTPath>)this.joinPaths.get(alias);
            if (paths == null) {
                paths = new HashMap<ASTPath, ASTPath>();
                this.joinPaths.put(alias, paths);
            }
            if ((oldPath = paths.put(path, path)) != null && oldPath.innerJoin) {
                path.innerJoin = true;
            }
        }
    }

    private void addInnerJoinPath(ASTPath path) {
        if (path.size() > 1 && path.isCMRField(1)) {
            String identifier = path.getPath(0);
            String alias = this.aliasManager.getAlias(identifier);
            HashMap<ASTPath, ASTPath> paths = (HashMap<ASTPath, ASTPath>)this.joinPaths.get(alias);
            if (paths == null) {
                paths = new HashMap<ASTPath, ASTPath>();
                this.joinPaths.put(alias, paths);
            }
            path.innerJoin = true;
            paths.put(path, path);
        }
    }

    private Object[] childrenToStringArr(int numChildren, Node node) {
        Object[] args = new Object[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            args[i] = node.jjtGetChild(i).jjtAccept(this, new StringBuffer()).toString();
        }
        return args;
    }

    private ASTPath getPathFromChildren(Node selectFunction) {
        for (int childInd = 0; childInd < selectFunction.jjtGetNumChildren(); ++childInd) {
            ASTPath path;
            Node child = selectFunction.jjtGetChild(childInd);
            if (child instanceof ASTPath) {
                return (ASTPath)child;
            }
            if (!(child instanceof SelectFunction) || (path = this.getPathFromChildren(child)) == null) continue;
            return path;
        }
        return null;
    }

    private void setTypeFactory(JDBCTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.typeMapping = typeFactory.getTypeMapping();
        this.aliasManager = new AliasManager(this.typeMapping.getAliasHeaderPrefix(), this.typeMapping.getAliasHeaderSuffix(), this.typeMapping.getAliasMaxLength());
    }

    private Class getParameterType(int index) {
        int zeroBasedIndex = index - 1;
        Class[] params = this.parameterTypes;
        if (zeroBasedIndex < params.length) {
            return params[zeroBasedIndex];
        }
        return null;
    }

    private void verifyParameterEntityType(int number, JDBCAbstractEntityBridge entity) {
        Class parameterType = this.getParameterType(number);
        Class remoteClass = entity.getRemoteInterface();
        Class localClass = entity.getLocalInterface();
        if (!(localClass != null && localClass.isAssignableFrom(parameterType) || remoteClass != null && remoteClass.isAssignableFrom(parameterType))) {
            throw new IllegalStateException("Only like types can be compared: from entity=" + entity.getEntityName() + " to parameter type=" + parameterType);
        }
    }

    private void reset() {
        this.returnType = null;
        this.parameterTypes = null;
        this.readAhead = null;
        this.inputParameters.clear();
        this.selectObject = null;
        this.selectManager = null;
        this.typeFactory = null;
        this.typeMapping = null;
        this.aliasManager = null;
        this.forceDistinct = false;
        this.limitParam = 0;
        this.limitValue = 0;
        this.offsetParam = 0;
        this.offsetValue = 0;
        this.leftJoinCMRList.clear();
        this.onFindCMRJoin = null;
        this.countCompositePk = false;
        this.joinPaths.clear();
        this.identifierToTable.clear();
        this.joinedAliases.clear();
    }
}

