/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.system.Registry;

public class SecurityInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;
    protected RunAsIdentity runAsIdentity;
    protected Map securityRoles;
    protected AuthenticationObserver authenticationObserver;
    protected Method ejbTimeout;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            this.securityManager = container.getSecurityManager();
            this.realmMapping = container.getRealmMapping();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        super.start();
        this.authenticationObserver = (AuthenticationObserver)Registry.lookup((Object)"SecurityInterceptor.AuthenticationObserver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    private void checkSecurityAssociation(Invocation mi) throws Exception {
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        RunAsIdentity callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (callerRunAsIdentity == null) {
            Subject subject = new Subject();
            if (!this.securityManager.isValid(principal, credential, subject)) {
                Exception ex;
                if (this.authenticationObserver != null) {
                    this.authenticationObserver.authenticationFailed();
                }
                if ((ex = SecurityActions.getContextException()) != null) {
                    throw ex;
                }
                String msg = "Authentication exception, principal=" + principal;
                SecurityException e = new SecurityException(msg);
                throw e;
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            if (trace) {
                this.log.trace((Object)("Authenticated  principal=" + principal));
            }
        } else {
            SecurityActions.dupSubjectContext();
        }
        InvocationType iface = mi.getType();
        Set methodRoles = this.container.getMethodPermissions(mi.getMethod(), iface);
        if (methodRoles == null) {
            String method = mi.getMethod().getName();
            String msg = "No method permissions assigned to method=" + method + ", interface=" + iface;
            SecurityException e = new SecurityException(msg);
            throw e;
        }
        if (trace) {
            this.log.trace((Object)("method=" + mi.getMethod() + ", interface=" + iface + ", requiredRoles=" + methodRoles));
        }
        if (!methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            if (callerRunAsIdentity == null) {
                if (!this.realmMapping.doesUserHaveRole(principal, methodRoles)) {
                    Set userRoles = this.realmMapping.getUserRoles(principal);
                    String method = mi.getMethod().getName();
                    BeanMetaData beanMetaData = this.container.getBeanMetaData();
                    String msg = "Insufficient method permissions, principal=" + principal + ", ejbName=" + beanMetaData.getEjbName() + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", principalRoles=" + userRoles;
                    SecurityException e = new SecurityException(msg);
                    throw e;
                }
            } else if (!callerRunAsIdentity.doesUserHaveRole(methodRoles)) {
                String method = mi.getMethod().getName();
                BeanMetaData beanMetaData = this.container.getBeanMetaData();
                String msg = "Insufficient method permissions, principal=" + principal + ", ejbName=" + beanMetaData.getEjbName() + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
                SecurityException e = new SecurityException(msg);
                throw e;
            }
        }
    }

    public static interface AuthenticationObserver {
        public static final String KEY = "SecurityInterceptor.AuthenticationObserver";

        public void authenticationFailed();
    }
}

