/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.TimerTask;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.ejb.plugins.LRUEnterpriseContextCachePolicy;
import org.jboss.ejb.plugins.StatefulSessionInstanceCache;
import org.jboss.metadata.MetaData;
import org.jboss.util.LRUCachePolicy;
import org.w3c.dom.Element;

public class LRUStatefulContextCachePolicy
extends LRUEnterpriseContextCachePolicy {
    private long m_maxBeanLife;
    private TimerTask m_remover;
    private long m_removerPeriod;
    private StatefulSessionInstanceCache ssiCache;

    public LRUStatefulContextCachePolicy(AbstractInstanceCache eic) {
        super(eic);
        this.ssiCache = (StatefulSessionInstanceCache)eic;
    }

    public void start() {
        super.start();
        if (this.m_maxBeanLife > 0L) {
            this.m_remover = new RemoverTask(this.m_removerPeriod);
            long delay = (long)(Math.random() * (double)this.m_removerPeriod);
            tasksTimer.schedule(this.m_remover, delay, this.m_removerPeriod);
        }
    }

    public void stop() {
        if (this.m_remover != null) {
            this.m_remover.cancel();
        }
        super.stop();
    }

    public void importXml(Element element) throws DeploymentException {
        super.importXml(element);
        String rp = MetaData.getElementContent(MetaData.getOptionalChild(element, "remover-period"));
        String ml = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-bean-life"));
        try {
            if (rp != null) {
                int p = Integer.parseInt(rp);
                if (p <= 0) {
                    throw new DeploymentException("Remover period can't be <= 0");
                }
                this.m_removerPeriod = p * 1000;
            }
            if (ml != null) {
                int a = Integer.parseInt(ml);
                if (a <= 0) {
                    throw new DeploymentException("Max bean life can't be <= 0");
                }
                this.m_maxBeanLife = a * 1000;
            }
        }
        catch (NumberFormatException x) {
            throw new DeploymentException("Can't parse policy configuration", (Throwable)x);
        }
    }

    protected class RemoverTask
    extends LRUEnterpriseContextCachePolicy.OveragerTask {
        protected RemoverTask(long period) {
            super(period);
        }

        protected String getTaskLogMessage() {
            return "Removing from cache bean";
        }

        protected void kickOut(LRUCachePolicy.LRUCacheEntry entry) {
            LRUStatefulContextCachePolicy.this.remove(entry.m_key);
        }

        protected long getMaxAge() {
            return LRUStatefulContextCachePolicy.this.m_maxBeanLife;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LRUStatefulContextCachePolicy.this.ssiCache == null) {
                this.cancel();
                return;
            }
            Object object = LRUStatefulContextCachePolicy.this.ssiCache.getCacheLock();
            synchronized (object) {
                LRUEnterpriseContextCachePolicy.log.debug((Object)"Running RemoverTask");
                super.run();
                LRUEnterpriseContextCachePolicy.log.debug((Object)("RemoverTask, PassivatedCount=" + LRUStatefulContextCachePolicy.this.ssiCache.getPassivatedCount()));
            }
            try {
                LRUStatefulContextCachePolicy.this.ssiCache.removePassivated(this.getMaxAge() - super.getMaxAge());
                LRUEnterpriseContextCachePolicy.log.debug((Object)"RemoverTask, done");
            }
            catch (Throwable e) {
                LRUEnterpriseContextCachePolicy.log.debug((Object)"Error during removals", e);
            }
        }
    }
}

