/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerExt;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.ejb.BeanMetaDataPolicyContextHandler;
import org.jboss.ejb.EJBArgsPolicyContextHandler;
import org.jboss.ejb.EJBDeployerMBean;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.SOAPMsgPolicyContextHandler;
import org.jboss.ejb.plugins.EnterpriseBeanPolicyContextHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.verifier.BeanVerifier;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationListener;
import org.w3c.dom.Element;

public class EJBDeployer
extends SubDeployerSupport
implements EJBDeployerMBean {
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"400:.jar"};
    private ServiceControllerMBean serviceController;
    private HashMap deployments = new HashMap();
    private boolean verifyDeployments;
    private boolean verifierVerbose;
    private boolean strictVerifier;
    private boolean metricsEnabled;
    private boolean validateDTDs;
    private ObjectName webServiceName;
    private ObjectName transactionManagerServiceName;
    private TransactionManager tm;
    private boolean callByValue;
    private SubDeployerExt thisProxy;

    public EJBDeployer() {
        this.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public Iterator listDeployedApplications() {
        return this.deployments.values().iterator();
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.tm = (TransactionManager)this.getServer().getAttribute(this.transactionManagerServiceName, "TransactionManager");
        Set keys = PolicyContext.getHandlerKeys();
        if (!keys.contains("javax.ejb.EnterpriseBean")) {
            EnterpriseBeanPolicyContextHandler beanHandler = new EnterpriseBeanPolicyContextHandler();
            PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)beanHandler, (boolean)false);
        }
        if (!keys.contains("org.jboss.ejb.BeanMetaData")) {
            BeanMetaDataPolicyContextHandler metadataHandler = new BeanMetaDataPolicyContextHandler();
            PolicyContext.registerHandler((String)"org.jboss.ejb.BeanMetaData", (PolicyContextHandler)metadataHandler, (boolean)false);
        }
        if (!keys.contains("javax.ejb.arguments")) {
            EJBArgsPolicyContextHandler argsHandler = new EJBArgsPolicyContextHandler();
            PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)argsHandler, (boolean)false);
        }
        if (!keys.contains("javax.xml.soap.SOAPMessage")) {
            SOAPMsgPolicyContextHandler msgHandler = new SOAPMsgPolicyContextHandler();
            PolicyContext.registerHandler((String)"javax.xml.soap.SOAPMessage", (PolicyContextHandler)msgHandler, (boolean)false);
        }
        this.thisProxy = (SubDeployerExt)MBeanProxyExt.create(SubDeployerExt.class, (ObjectName)super.getServiceName(), (MBeanServer)super.getServer());
        this.mainDeployer.addDeployer((SubDeployer)this.thisProxy);
    }

    protected void stopService() throws Exception {
        for (DeploymentInfo di : this.deployments.values()) {
            this.stop(di);
        }
        for (DeploymentInfo di : new ArrayList(this.deployments.values())) {
            this.destroy(di);
        }
        this.deployments.clear();
        this.mainDeployer.removeDeployer((SubDeployer)this.thisProxy);
        this.serviceController = null;
        this.tm = null;
    }

    public void setVerifyDeployments(boolean verify) {
        this.verifyDeployments = verify;
    }

    public boolean getVerifyDeployments() {
        return this.verifyDeployments;
    }

    public void setVerifierVerbose(boolean verbose) {
        this.verifierVerbose = verbose;
    }

    public boolean getVerifierVerbose() {
        return this.verifierVerbose;
    }

    public void setStrictVerifier(boolean strictVerifier) {
        this.strictVerifier = strictVerifier;
    }

    public boolean getStrictVerifier() {
        return this.strictVerifier;
    }

    public void setMetricsEnabled(boolean enable) {
        this.metricsEnabled = enable;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public ObjectName getWebServiceName() {
        return this.webServiceName;
    }

    public void setWebServiceName(ObjectName webServiceName) {
        this.webServiceName = webServiceName;
    }

    public ObjectName getTransactionManagerServiceName() {
        return this.transactionManagerServiceName;
    }

    public void setTransactionManagerServiceName(ObjectName transactionManagerServiceName) {
        this.transactionManagerServiceName = transactionManagerServiceName;
    }

    public boolean accepts(DeploymentInfo di) {
        if (!super.accepts(di)) {
            return false;
        }
        boolean accepts = false;
        try {
            String ddStr;
            URL dd = di.localCl.findResource("META-INF/ejb-jar.xml");
            if (dd == null) {
                return false;
            }
            String urlStr = di.url.getFile();
            if (di.localUrl != null) {
                urlStr = di.localUrl.toString();
            }
            if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                accepts = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accepts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DeploymentInfo di) throws DeploymentException {
        block7: {
            this.log.debug((Object)("init, " + di.shortName));
            try {
                File file;
                di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/ejb-jar.xml")) : di.url;
                XmlFileLoader xfl = new XmlFileLoader();
                InputStream in = di.localCl.getResourceAsStream("META-INF/jboss.xml");
                if (in == null) break block7;
                try {
                    Element jboss = xfl.getDocument(in, "META-INF/jboss.xml").getDocumentElement();
                    Element loader = MetaData.getOptionalChild(jboss, "loader-repository");
                    if (loader != null) {
                        LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
                        di.setRepositoryInfo(config);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                if (e instanceof DeploymentException) {
                    throw (DeploymentException)e;
                }
                throw new DeploymentException("failed to initialize", (Throwable)e);
            }
        }
        super.init(di);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        super.processNestedDeployments(di);
    }

    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("create, " + di.shortName));
        ApplicationMetaData ejbMetaData = null;
        try {
            URL loaderURL = di.localUrl != null ? di.localUrl : di.url;
            di.annotationsCl = new URLClassLoader(new URL[]{loaderURL}, (ClassLoader)di.ucl);
            XmlFileLoader efm = new XmlFileLoader(this.validateDTDs);
            efm.setClassLoader(di.localCl);
            URL alternativeDD = null;
            if (di.alternativeDD != null) {
                String contentsDir = new File(di.url.getPath()).getParent();
                alternativeDD = new URL("file:/" + contentsDir + "/" + di.alternativeDD);
            }
            ejbMetaData = efm.load(alternativeDD);
            di.metaData = ejbMetaData;
            if (di.parent != null && di.parent.metaData instanceof J2eeApplicationMetaData) {
                J2eeApplicationMetaData appMetaData = (J2eeApplicationMetaData)di.parent.metaData;
                if (ejbMetaData.getSecurityDomain() == null) {
                    ejbMetaData.setSecurityDomain(appMetaData.getSecurityDomain());
                }
                if (ejbMetaData.getUnauthenticatedPrincipal() == null) {
                    ejbMetaData.setUnauthenticatedPrincipal(appMetaData.getUnauthenticatedPrincipal());
                }
                ejbMetaData.getAssemblyDescriptor().mergeSecurityRoles(appMetaData.getSecurityRoles());
            }
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("Failed to load metaData", (Throwable)e);
        }
        if (this.verifyDeployments) {
            boolean allOK = true;
            try {
                BeanVerifier verifier = new BeanVerifier();
                verifier.addVerificationListener(new VerificationListener(){
                    Logger verifierLog = Logger.getLogger(EJBDeployer.class, (String)"verifier");

                    public void beanChecked(VerificationEvent event) {
                        this.verifierLog.debug((Object)("Bean checked: " + event.getMessage()));
                    }

                    public void specViolation(VerificationEvent event) {
                        this.verifierLog.warn((Object)("EJB spec violation: " + (EJBDeployer.this.verifierVerbose ? event.getVerbose() : event.getMessage())));
                    }
                });
                this.log.debug((Object)("Verifying " + di.url));
                verifier.verify(di.url, (ApplicationMetaData)di.metaData, (ClassLoader)di.ucl);
                allOK = verifier.getSuccess();
            }
            catch (Throwable t) {
                this.log.warn((Object)"Verify failed; continuing", t);
                allOK = false;
            }
            if (this.strictVerifier && !allOK) {
                throw new DeploymentException("Verification of Enterprise Beans failed, see above for error messages.");
            }
        }
        try {
            ObjectName ejbModuleName;
            EjbModule ejbModule = new EjbModule(di, this.tm, this.webServiceName);
            String name = ejbMetaData.getJmxName();
            if (name == null) {
                name = "jboss.j2ee:service=EjbModule,module=" + di.shortName;
            }
            if (this.server.isRegistered(ejbModuleName = ObjectNameConverter.convert((String)name))) {
                this.log.debug((Object)("The EJBModule name: " + ejbModuleName + "is already registered, adding uid=" + System.identityHashCode(ejbModule)));
                name = name + ",uid=" + System.identityHashCode(ejbModule);
                ejbModuleName = ObjectNameConverter.convert((String)name);
            }
            this.server.registerMBean(ejbModule, ejbModuleName);
            di.deployedObject = ejbModuleName;
            this.log.debug((Object)("Deploying: " + di.url));
            this.serviceController.create(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during create of EjbModule: " + di.url, (Throwable)e);
        }
        super.create(di);
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName)));
            this.serviceController.start(di.deployedObject);
            this.log.info((Object)("Deployed: " + di.url));
            this.deployments.put(di.url, di);
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("Could not deploy " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.log.info((Object)("Undeploying: " + di.url));
        try {
            if (di.deployedObject != null) {
                this.serviceController.stop(di.deployedObject);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping ejb module: " + di.url, (Throwable)e);
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        try {
            if (di.deployedObject != null) {
                this.serviceController.destroy(di.deployedObject);
                this.serviceController.remove(di.deployedObject);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("problem destroying ejb module: " + di.url, (Throwable)e);
        }
        super.destroy(di);
    }
}

