/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.EARDeployerMBean;
import org.jboss.deployment.EARDeployment;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.file.JarUtils;
import org.w3c.dom.Element;

public class EARDeployer
extends SubDeployerSupport
implements EARDeployerMBean {
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"650:.ear"};
    private ServiceControllerMBean serviceController;
    private boolean isolated = false;
    private boolean callByValue = false;

    public EARDeployer() {
        this.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        super.startService();
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            File file;
            this.log.info((Object)("Init J2EE application: " + di.url));
            InputStream in = di.localCl.getResourceAsStream("META-INF/application.xml");
            if (in == null) {
                throw new DeploymentException("No META-INF/application.xml found");
            }
            XmlFileLoader xfl = new XmlFileLoader(false);
            J2eeApplicationMetaData metaData = new J2eeApplicationMetaData();
            Element application = xfl.getDocument(in, "META-INF/application.xml").getDocumentElement();
            metaData.importXml(application);
            di.metaData = metaData;
            in.close();
            Element loader = null;
            in = di.localCl.getResourceAsStream("META-INF/jboss-app.xml");
            if (in != null) {
                xfl = new XmlFileLoader(true);
                Element jbossApp = xfl.getDocument(in, "META-INF/jboss-app.xml").getDocumentElement();
                in.close();
                metaData.importXml(jbossApp);
                loader = MetaData.getOptionalChild(jbossApp, "loader-repository");
            }
            this.initLoaderRepository(di, loader);
            di.watch = di.url.getProtocol().equals("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/application.xml")) : di.url;
            File parentDir = null;
            HashMap<String, URL> extractedJars = new HashMap<String, URL>();
            if (di.isDirectory) {
                parentDir = new File(di.localUrl.getFile());
            } else {
                String urlPrefix = "jar:" + di.localUrl + "!/";
                JarFile jarFile = new JarFile(di.localUrl.getFile());
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    try {
                        URL url = new URL(urlPrefix + name);
                        if (metaData.hasModule(name)) {
                            URL nestedURL = JarUtils.extractNestedJar((URL)url, (File)this.tempDeployDir);
                            extractedJars.put(name, nestedURL);
                            this.log.debug((Object)("Extracted deployable content: " + name));
                            continue;
                        }
                        if (entry.isDirectory()) continue;
                        JarUtils.extractNestedJar((URL)url, (File)this.tempDeployDir);
                        this.log.debug((Object)("Extracted non-deployable content: " + name));
                    }
                    catch (MalformedURLException mue) {
                        this.log.warn((Object)("Jar entry invalid. Ignoring: " + name), (Throwable)mue);
                    }
                    catch (IOException ex) {
                        this.log.warn((Object)("Failed to extract nested jar. Ignoring: " + name), (Throwable)ex);
                    }
                }
            }
            String contextID = di.shortName;
            PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
            di.context.put("javax.security.jacc.PolicyConfiguration", pc);
            Iterator iter = metaData.getModules();
            while (iter.hasNext()) {
                J2eeModuleMetaData mod = (J2eeModuleMetaData)iter.next();
                String fileName = mod.getFileName();
                if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                DeploymentInfo sub = null;
                if (di.isDirectory) {
                    File f = new File(parentDir, fileName);
                    sub = new DeploymentInfo(f.toURL(), di, this.getServer());
                } else {
                    URL nestedURL = (URL)extractedJars.get(fileName);
                    if (nestedURL == null) {
                        throw new DeploymentException("Failed to find module file: " + fileName);
                    }
                    sub = new DeploymentInfo(nestedURL, di, this.getServer());
                }
                if (mod.isWeb()) {
                    sub.webContext = mod.getWebContext();
                }
                if (mod.alternativeDD != null) {
                    sub.alternativeDD = mod.alternativeDD;
                }
                this.log.debug((Object)("Deployment Info: " + sub + ", isDirectory: " + sub.isDirectory));
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)"Error in accessing application metadata: ", (Throwable)e);
        }
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        super.create(di);
        try {
            ObjectName objectName;
            EARDeployment earDeployment = new EARDeployment(di);
            String name = earDeployment.getJMXName();
            di.deployedObject = objectName = new ObjectName(name);
            this.server.registerMBean(earDeployment, objectName);
            this.serviceController.create(di.deployedObject);
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Error during create of EARDeployment: " + di.url), (Throwable)e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        super.start(di);
        try {
            PolicyConfiguration pc = (PolicyConfiguration)di.context.get("javax.security.jacc.PolicyConfiguration");
            pc.commit();
            Policy.getPolicy().refresh();
            this.serviceController.start(di.deployedObject);
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Error during start of EARDeployment: " + di.url), (Throwable)e);
        }
        this.log.info((Object)("Started J2EE application: " + di.url));
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        try {
            if (di.deployedObject != null) {
                this.serviceController.stop(di.deployedObject);
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Error during stop of EARDeployment: " + di.url), (Throwable)e);
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.log.info((Object)("Undeploying J2EE application, destroy step: " + di.url));
        try {
            if (di.deployedObject != null) {
                this.serviceController.destroy(di.deployedObject);
                this.serviceController.remove(di.deployedObject);
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Error during destroy of EARDeployment: " + di.url), (Throwable)e);
        }
        super.destroy(di);
        this.log.info((Object)("Undeployed J2EE application: " + di.url));
    }

    protected void initLoaderRepository(DeploymentInfo di, Element loader) throws Exception {
        if (loader == null) {
            if (this.isolated && di.parent == null) {
                J2eeApplicationMetaData metaData = (J2eeApplicationMetaData)di.metaData;
                String name = EARDeployment.getJMXName(metaData, di) + ",extension=LoaderRepository";
                ObjectName objectName = new ObjectName(name);
                LoaderRepositoryFactory.LoaderRepositoryConfig config = new LoaderRepositoryFactory.LoaderRepositoryConfig();
                config.repositoryName = objectName;
                di.setRepositoryInfo(config);
            }
            return;
        }
        LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
        di.setRepositoryInfo(config);
    }

    protected boolean isDeployable(String name, URL url) {
        return super.isDeployable(name, url) || name.endsWith("-ds.xml") || name.endsWith("-service.xml") || name.endsWith(".har");
    }

    protected void processNestedDeployments(DeploymentInfo di) {
    }
}

