/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderers.ajax;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.renderer.AjaxContainerRenderer;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.RendererUtils;

public class AjaxPageRenderer
extends AjaxContainerRenderer {
    public static final String RENDERER_TYPE = "org.ajax4jsf.components.AjaxPageRenderer";

    public void doEncodeBegin(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        AjaxContainer ajax = (AjaxContainer)component;
        ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
        String contentType = (String)component.getAttributes().get("contentType");
        if (null != contentType) {
            response.setContentType(contentType + "; charset=" + out.getCharacterEncoding());
        }
        out.startElement("html", component);
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        this.getUtils().encodeAttribute(context, component, "namespace", "xmlns");
        if (!ajax.isAjaxRequest()) {
            Object title;
            out.startElement("head", component);
            UIComponent headFacet = component.getFacet("head");
            if (headFacet != null) {
                this.renderChild(context, headFacet);
            }
            if (null != (title = component.getAttributes().get("pageTitle"))) {
                out.startElement("title", component);
                out.writeText(title, "pageTitle");
                out.endElement("title");
            }
            out.endElement("head");
        }
        out.startElement("body", component);
        this.getUtils().encodePassThru(context, component);
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodeAttribute(context, component, "onload");
        this.getUtils().encodeAttribute(context, component, "onunload");
    }

    public void doEncodeEnd(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        out.endElement("body");
        out.endElement("html");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!AjaxRendererUtils.isAjaxRequest(context)) {
            super.encodeChildren(context, component);
        } else {
            UIComponent submittedComponent = ((AjaxViewRoot)context.getViewRoot()).getSubmittedRegion(context);
            if (null == submittedComponent || component == submittedComponent) {
                this.encodeAjax(context, component);
            } else {
                ((AjaxContainer)submittedComponent).encodeAjax(context);
            }
        }
    }

    public boolean getRendersChildren() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxRendererUtils.isAjaxRequest(context);
    }
}

