/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.image.imageio.gif;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import org.ajax4jsf.framework.util.image.GIFEncoder;
import org.ajax4jsf.framework.util.image.imageio.gif.GIFImageWriteParam;
import org.ajax4jsf.framework.util.image.imageio.gif.GIFImageWriterSpi;
import org.ajax4jsf.framework.util.message.Messages;

public class GIFImageWriter
extends ImageWriter {
    GIFEncoder encoder = new GIFEncoder();

    public GIFImageWriter(GIFImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        RenderedImage ri;
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException(Messages.getMessage(Messages.CANNOT_WRITE_RASTERS));
        }
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException(Messages.getMessage(Messages.NULL_OUTPUT_ERROR));
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        if (!((ri = image.getRenderedImage()) instanceof BufferedImage)) {
            throw new IOException(Messages.getMessage(Messages.IMAGE_NOT_BUFFERED_ERROR));
        }
        if (!(output instanceof DataOutput)) {
            throw new IOException(Messages.getMessage(Messages.NOT_DATA_OUTPUT_ERROR));
        }
        this.encoder.encode((BufferedImage)ri, (DataOutput)output, param.getProgressiveMode() != 0, null);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }
}

