/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.framework.renderer.compiler.InvokeData;
import org.ajax4jsf.framework.renderer.compiler.MethodCacheState;
import org.ajax4jsf.framework.renderer.compiler.Signature;
import org.ajax4jsf.framework.renderer.compiler.TemplateContext;
import org.ajax4jsf.framework.util.message.Messages;

class Invoker {
    String methodName;

    Invoker() {
    }

    InvokeData invokeMethod(TemplateContext context, MethodCacheState state) {
        throw new FacesException(Messages.getMessage(Messages.RENDERER_METHOD_NOT_SET_ERROR));
    }

    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
    }

    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
    }

    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
    }

    InvokeData invokeMethod(TemplateContext context, Map methods, Class cls, Object object, MethodCacheState state) {
        Method method = this.provideMethod(methods, cls, object, state);
        return new InvokeData(context, method, object, state.current.arguments);
    }

    Object invokeMethod(InvokeData data) {
        if (data.method != null) {
            try {
                return data.method.invoke(data.object, data.arguments);
            }
            catch (InvocationTargetException e) {
                this.handleInvocationTargetException(data.context, e);
            }
            catch (IllegalAccessException e) {
                this.handleIllegalAccessException(data.context, e);
            }
        }
        this.handleMethodNotFoundException(data.context);
        return null;
    }

    public Class getInvokedClass(TemplateContext context) {
        return null;
    }

    private Method provideMethod(Map methods, Class cls, Object object, MethodCacheState state) {
        if (state.method != null) {
            return state.method;
        }
        if (methods.size() > 0) {
            for (int i = 0; i < state.signatures.length; ++i) {
                state.method = (Method)methods.get(this.getClassesKey(state.signatures[i].arguments));
                if (state.method == null) continue;
                state.current = state.signatures[i];
                return state.method;
            }
        }
        if (cls == null && object != null) {
            cls = object.getClass();
        }
        Method[] ms = cls.getMethods();
        for (int m = 0; m < ms.length; ++m) {
            Class[] cs;
            Signature s;
            if (!ms[m].getName().equals(this.methodName) || object == null && !Modifier.isStatic(ms[m].getModifiers()) || (s = this.getMatchingArguments(cs = ms[m].getParameterTypes(), state.signatures)) == null) continue;
            state.current = s;
            state.method = ms[m];
            methods.put(this.getClassesKey(s.arguments), ms[m]);
            return state.method;
        }
        return null;
    }

    private String getClassesKey(Object[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String dk = args[i] == null ? "null" : args[i].getClass().getName();
            sb.append(";").append(dk);
        }
        return sb.toString();
    }

    private Signature getMatchingArguments(Class[] cs, Signature[] sgs) {
        for (int i = 0; i < sgs.length; ++i) {
            if (!Invoker.isMatching(cs, sgs[i].arguments)) continue;
            return sgs[i];
        }
        return null;
    }

    static boolean isMatching(Class[] cs, Object[] args) {
        if (cs.length != args.length) {
            return false;
        }
        for (int i = 0; i < cs.length; ++i) {
            if (args[i] == null || cs[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }
}

