/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.ajax4jsf.framework.util.javascript.JSEncoder;
import org.ajax4jsf.framework.util.message.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSContentHandler
extends Writer
implements ContentHandler,
LexicalHandler {
    protected Writer outputWriter;
    private static final JSEncoder encoder = new JSEncoder();
    private static final char[] S_EOL = System.getProperty("line.separator").toCharArray();
    private static final char[] S_DOCUMENT_START = "(".toCharArray();
    private static final char[] S_DOCUMENT_ENF = ");".toCharArray();
    private static final char[] S_DOCUMENT_3 = "\"?>".toCharArray();
    private static final char[] S_OBJECT_START = "{".toCharArray();
    private static final char[] S_OBJECT_END = "}".toCharArray();
    private static final char[] S_ELEMENT_START = "new E(".toCharArray();
    private static final char[] S_ELEMENT_CLOSE = ")".toCharArray();
    private static final char[] S_ATTRIBUTES_END = "}".toCharArray();
    private static final char[] S_ATTRIBUTES_START = ",{".toCharArray();
    private static final char[] S_ELEMENT_END_START_TAG = ",[".toCharArray();
    private static final char[] S_ELEMENT_END = "])".toCharArray();
    private static final char[] S_TEXT_START = "new T('".toCharArray();
    private static final char[] S_TEXT_END = "')".toCharArray();
    private static final char[] S_CDATA_START = "new D('".toCharArray();
    private static final char[] S_CDATA_END = "')".toCharArray();
    private static final char[] S_COMMENT_START = "new C('".toCharArray();
    private static final char[] S_COMMENT_END = "')".toCharArray();
    private static final char[] S_PROCINSTR_START = "<?".toCharArray();
    private static final char[] S_PROCINSTR_END = "?>".toCharArray();
    private static final char C_LT = '<';
    private static final char C_GT = '>';
    private static final char C_SPACE = ' ';
    private static final char C_QUOTE = '\'';
    private static final char C_NSSEP = ':';
    private static final char C_COMMA = ',';
    private static final boolean DEBUG = false;
    private boolean hanging_element = false;
    private boolean processing_prolog = true;
    private boolean processing_dtd = false;
    private boolean processing_cdata = false;
    protected int level;
    protected char[] indentBuffer;
    protected String jsFunction;
    protected ArrayList parameters;
    private int currentParameter;
    private int src;
    private Locator locator;
    protected Map headers;
    protected String requestId;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";

    public JSContentHandler() {
    }

    public JSContentHandler(Writer outputWriter, String function, String requestId, Map headers) {
        this.outputWriter = outputWriter;
        this.jsFunction = function;
        this.headers = headers;
        this.requestId = requestId;
    }

    public void close() throws IOException {
        this.outputWriter.close();
    }

    public void flush() throws IOException {
        this.outputWriter.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.outputWriter.write(cbuf, off, len);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.processing_prolog || this.level <= 0) {
            return;
        }
        try {
            if (!this.closeElement(false) && !this.processing_cdata) {
                this.write(44);
            }
            if (!this.processing_cdata) {
                this.write(S_TEXT_START);
            }
            this.encode(ch, start, length);
            if (!this.processing_cdata) {
                this.write(S_TEXT_END);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endDocument() throws SAXException {
        if (this.level != 0) {
            throw new SAXException(Messages.getMessage(Messages.OPEN_CLOSE_TAGS_DO_NOT_MATCH_ERROR));
        }
        try {
            this.write(S_DOCUMENT_ENF);
            this.write(S_EOL);
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.level;
        if (this.closeElement(true)) {
            return;
        }
        try {
            this.write(S_ELEMENT_END);
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    protected boolean closeElement(boolean end_element) throws SAXException {
        if (!this.hanging_element) {
            return false;
        }
        try {
            if (end_element) {
                this.write(S_ELEMENT_CLOSE);
            } else {
                this.write(S_ELEMENT_END_START_TAG);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
        this.hanging_element = false;
        return true;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    protected String getLocation() {
        if (this.locator == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" (");
        if (this.getSystemId() != null) {
            buf.append(this.getSystemId());
            buf.append(' ');
        }
        buf.append("line " + this.getLineNumber());
        buf.append(" col " + this.getColumnNumber());
        buf.append(')');
        return buf.toString();
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.processing_prolog = false;
        this.processing_cdata = false;
        this.level = 0;
        try {
            this.write(this.jsFunction);
            this.write(S_DOCUMENT_START);
            this.write(S_EOL);
            this.write(39);
            this.write(this.requestId);
            this.write(39);
            this.write(44);
            this.write(S_OBJECT_START);
            Iterator keys = this.headers.entrySet().iterator();
            while (keys.hasNext()) {
                Map.Entry element = keys.next();
                this.write(39);
                this.encode(element.getKey().toString());
                this.write(39);
                this.write(58);
                this.write(39);
                this.encode(element.getValue().toString());
                this.write(39);
                if (!keys.hasNext()) continue;
                this.write(44);
            }
            this.write(S_OBJECT_END);
            this.write(44);
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
        try {
            this.write(S_EOL);
        }
        catch (IOException e1) {
            throw new SAXException("Write error", e1);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (!this.closeElement(false) && this.level > 0) {
                this.write(44);
            }
            this.write(S_ELEMENT_START);
            this.write(39);
            this.write(qName);
            this.write(39);
            this.write(S_ATTRIBUTES_START);
            for (int x = 0; x < attributes.getLength(); ++x) {
                String attrName;
                this.write(32);
                if (0 != x) {
                    this.write(44);
                }
                if ((attrName = attributes.getQName(x)).equalsIgnoreCase("class")) {
                    attrName = "className";
                }
                this.write(attrName);
                this.write(58);
                this.write(39);
                this.encode(attributes.getValue(x));
                this.write(39);
            }
            this.write(S_ATTRIBUTES_END);
            ++this.level;
            this.hanging_element = true;
        }
        catch (IOException e) {
            throw new SAXException("write error", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.processing_prolog || this.level <= 0) {
            return;
        }
        try {
            if (!this.closeElement(false)) {
                this.write(44);
            }
            this.write(S_COMMENT_START);
            this.encode(ch, start, length);
            this.write(S_COMMENT_END);
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.processing_prolog || this.level <= 0) {
            return;
        }
        try {
            if (this.closeElement(false)) {
                return;
            }
            this.write(S_CDATA_END);
            this.processing_cdata = false;
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (this.processing_prolog || this.level <= 0) {
            return;
        }
        try {
            if (!this.closeElement(false)) {
                this.write(44);
            }
            this.write(S_CDATA_START);
            this.processing_cdata = true;
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    protected boolean writeParameter(int num) throws SAXException {
        String parameterValue = (String)this.parameters.get(num);
        if (num == this.src) {
            return false;
        }
        if (null != parameterValue) {
            try {
                this.write(39);
                this.write(parameterValue);
                this.write(39);
            }
            catch (IOException e) {
                throw new SAXException("write error", e);
            }
        }
        return true;
    }

    protected void writeIndent(int indent) throws SAXException {
        try {
            this.write("\n".toCharArray(), 0, 1);
            if (indent > 0) {
                this.write(this.assureIndentBuffer(indent), 0, indent);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    private char[] assureIndentBuffer(int size) {
        if (this.indentBuffer == null || this.indentBuffer.length < size) {
            this.indentBuffer = new char[size];
            Arrays.fill(this.indentBuffer, ' ');
        }
        return this.indentBuffer;
    }

    protected void encode(String data) throws SAXException {
        char[] array = data.toCharArray();
        this.encode(array, 0, array.length);
    }

    protected void encode(char[] data) throws SAXException {
        this.encode(data, 0, data.length);
    }

    protected void encode(char[] data, int start, int length) throws SAXException {
        int end = start + length;
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (start < 0 || start > data.length || length < 0 || end > data.length || end < 0) {
            throw new IndexOutOfBoundsException("Invalid data");
        }
        if (length == 0) {
            return;
        }
        try {
            for (int x = start; x < end; ++x) {
                char c = data[x];
                if (encoder.compile(c)) continue;
                if (start != x) {
                    this.write(data, start, x - start);
                }
                this.write(encoder.encode(c));
                start = x + 1;
            }
            if (start != end) {
                this.write(data, start, end - start);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }
}

