/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxRegionBrige;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.renderer.AjaxContainerRenderer;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class AjaxViewRoot
extends UIViewRoot
implements AjaxContainer {
    public static final String SUBMITTED_REGION_PARAM = "org.ajax4jsf.framework.ajax.SubmittedRegion";
    private static final String SUBMITTED_REGION_ID_PARAM = "org.ajax4jsf.framework.ajax.SubmittedRegionId";
    public static final String ROOT_ID = "_viewRoot";
    private boolean havePage = false;
    private boolean havePageChecked = false;
    private Map _ajaxRegions = new HashMap();
    protected AjaxRegionBrige _brige = new AjaxRegionBrige((UIComponent)this);
    private static final String EVENTS_PARAMETER = "org.ajax4jsf.framevork.FacesEvents";
    private static final String AJAX_EVENTS_PARAMETER = "org.ajax4jsf.framevork.AjaxFacesEvents";

    public AjaxViewRoot() {
        this.setId(ROOT_ID);
    }

    public String getRendererType() {
        return "javax.faces.ViewRoot";
    }

    public void addAjaxRegion(UIComponent region) {
        if (!(region instanceof AjaxContainer)) {
            throw new IllegalArgumentException(Messages.getMessage(Messages.ARGUMENT_IS_NOT_AJAX_REGION_ERROR, region.getClientId(this.getFacesContext())));
        }
        this._ajaxRegions.put(region.getClientId(this.getFacesContext()), AjaxRendererUtils.getAbsoluteId(region));
    }

    public String getAjaxRegionId(String regionId) {
        return (String)this._ajaxRegions.get(regionId);
    }

    public void setSubmittedRegion(String regionId) {
        UIComponent region = this.findComponent(regionId);
        AjaxContext state = AjaxContext.getCurrentInstance();
        if (null != region) {
            state.setSubmittedRegionId(regionId);
            state.setSubmittedRegion(region);
        }
    }

    public UIComponent getSubmittedRegion(FacesContext context) {
        String regionId;
        AjaxContext state = AjaxContext.getCurrentInstance(context);
        UIComponent region = state.getSubmittedRegion();
        if (null == region && null != (regionId = state.getSubmittedRegionId())) {
            region = this.findComponent(regionId);
            state.setSubmittedRegion(region);
        }
        return region;
    }

    public void resetSubmittedRegionInstance() {
        AjaxContext.getCurrentInstance().setSubmittedRegion(null);
    }

    public void addAjaxArea(String toRender) {
        this._brige.addAjaxArea(toRender);
    }

    public void addAjaxAreas(Collection collection) {
        this._brige.addAjaxAreas(collection);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this._brige.broadcast(event);
    }

    public MethodBinding getAjaxListener() {
        return this._brige.getAjaxListener();
    }

    public Set getAjaxAreasToRender() {
        return this._brige.getAjaxAreasToRender();
    }

    public Set getAjaxRenderedAreas() {
        return this._brige.getAjaxRenderedAreas();
    }

    public boolean isAjaxRequest() {
        return this._brige.isAjaxRequest();
    }

    public boolean isImmediate() {
        return this._brige.isImmediate();
    }

    public boolean isSubmitted() {
        return this._brige.isSubmitted();
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException(Messages.getMessage(Messages.NULL_EVENT_SUBMITTED_ERROR));
        }
        if (event.getPhaseId().compareTo((Object)PhaseId.RENDER_RESPONSE) == 0) {
            this.getAjaxEventsQueue(this.getFacesContext()).add((Object)event);
        } else {
            this.getEventsQueue(this.getFacesContext(), event.getPhaseId()).add((Object)event);
        }
    }

    void broadcastEvents(FacesContext context, PhaseId phaseId) {
        Buffer[] events = this.getEvents(context);
        Buffer anyPhaseEvents = events[PhaseId.ANY_PHASE.getOrdinal()];
        Buffer phaseEvents = events[phaseId.getOrdinal()];
        if (phaseEvents.isEmpty() && anyPhaseEvents.isEmpty()) {
            return;
        }
        boolean haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
        boolean havePhaseEvents = !phaseEvents.isEmpty();
        do {
            this.processEvents(anyPhaseEvents, haveAnyPhaseEvents);
            this.processEvents(phaseEvents, havePhaseEvents);
            haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
            boolean bl = havePhaseEvents = !phaseEvents.isEmpty();
        } while (haveAnyPhaseEvents || havePhaseEvents);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    private void processEvents(Buffer phaseEventsQueue, boolean havePhaseEvents) {
        while (havePhaseEvents) {
            try {
                FacesEvent event = (FacesEvent)phaseEventsQueue.remove();
                UIComponent source = event.getComponent();
                try {
                    source.broadcast(event);
                }
                catch (AbortProcessingException e) {
                }
            }
            catch (BufferUnderflowException e) {
                havePhaseEvents = false;
            }
        }
    }

    public void broadcastAjaxEvents(FacesContext context) {
        Buffer queue;
        this.processEvents(queue, !(queue = this.getAjaxEventsQueue(context)).isEmpty());
    }

    private Buffer getEventsQueue(FacesContext context, PhaseId phase) {
        return this.getEvents(context)[phase.getOrdinal()];
    }

    private Buffer[] getEvents(FacesContext context) {
        return AjaxContext.getCurrentInstance(context).getEvents();
    }

    private Buffer getAjaxEventsQueue(FacesContext context) {
        return AjaxContext.getCurrentInstance(context).getAjaxEvents();
    }

    private void clearEvents(FacesContext context) {
        AjaxContext.getCurrentInstance(context).clearEvents();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.decode(context);
        UIComponent component = this.getSubmittedRegion(context);
        if (null == component) {
            Iterator it = this.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent childOrFacet = (UIComponent)it.next();
                childOrFacet.processDecodes(context);
            }
        } else {
            component.processDecodes(context);
        }
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        UIComponent component = this.getSubmittedRegion(context);
        if (null == component) {
            super.processUpdates(context);
        } else {
            component.processUpdates(context);
        }
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        UIComponent component = this.getSubmittedRegion(context);
        if (null == component) {
            super.processValidators(context);
        } else {
            component.processValidators(context);
        }
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void encodeBegin(FacesContext arg0) throws IOException {
        super.encodeBegin(arg0);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isAjaxRequest()) {
            UIComponent submittedComponent = this.getSubmittedRegion(context);
            if (null == submittedComponent) {
                this.encodeAjax(context);
            } else {
                ((AjaxContainer)submittedComponent).encodeAjax(context);
            }
        } else {
            super.encodeChildren(context);
        }
    }

    public void encodeEnd(FacesContext arg0) throws IOException {
        super.encodeEnd(arg0);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] mystate = (Object[])state;
        super.restoreState(context, mystate[0]);
        this._brige.restoreState(context, mystate[1]);
        this._ajaxRegions = (Map)AjaxViewRoot.restoreAttachedState((FacesContext)context, (Object)mystate[2]);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this._brige.saveState(context), AjaxViewRoot.saveAttachedState((FacesContext)context, (Object)this._ajaxRegions)};
        return state;
    }

    public String getViewId() {
        ViewIdHolder viewIdHolder = AjaxContext.getCurrentInstance().getViewIdHolder();
        String viewId = null != viewIdHolder ? viewIdHolder.getViewId() : super.getViewId();
        return viewId;
    }

    public void setAjaxListener(MethodBinding ajaxListener) {
        this._brige.setAjaxListener(ajaxListener);
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this._brige.setAjaxRequest(ajaxRequest);
    }

    public void setImmediate(boolean immediate) {
        this._brige.setImmediate(immediate);
    }

    public void setSubmitted(boolean submitted) {
        this._brige.setSubmitted(submitted);
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }

    public boolean isSelfRendered() {
        return false;
    }

    public void setSelfRendered(boolean selfRendered) {
    }

    public boolean isHavePage() {
        if (!this.havePageChecked) {
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent element = (UIComponent)iter.next();
                if (!"org.ajax4jsf.components.AjaxPageRenderer".equals(element.getRendererType())) continue;
                this.havePage = true;
                break;
            }
            this.havePageChecked = true;
        }
        return this.havePage;
    }

    public boolean isRenderRegionOnly() {
        return false;
    }

    public void setRenderRegionOnly(boolean reRenderPage) {
    }

    public void encodeAjax(FacesContext context) throws IOException {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            ((AjaxContainerRenderer)this.getRenderer(context)).encodeAjax(context, (UIComponent)this);
        }
    }
}

