/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.ajax.xmlfilter.FilterServletResponseWrapper;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.HeaderResourceProducer;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.skin.SkinNotFoundException;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxContext {
    public static final String AJAX_CONTEXT_KEY = "ajaxContext";
    public static final String SCRIPTS_PARAMETER = "org.ajax4jsf.framework.HEADER_SCRIPTS";
    public static final String STYLES_PARAMETER = "org.ajax4jsf.framework.HEADER_STYLES";
    public static final String RESPONSE_DATA_KEY = "_ajax:data";
    private static final Log log = LogFactory.getLog((Class)AjaxContext.class);
    private static Map contextClasses = new HashMap();
    Set ajaxAreasToRender = new HashSet();
    Set ajaxRenderedAreas = new HashSet();
    boolean ajaxRequest = false;
    boolean selfRender = false;
    Integer viewSequence = new Integer(1);
    String submittedRegionClientId = null;
    String submittedRegionId = null;
    UIComponent submittedRegion = null;
    FacesContext context = null;
    int uniqueIdCounter = 0;
    Buffer[] events;
    Buffer ajaxEvents = new UnboundedFifoBuffer();
    ViewIdHolder viewIdHolder = null;
    Map responseDataMap = new HashMap();

    public AjaxContext() {
        this.clearEvents();
    }

    public static AjaxContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance(context);
    }

    public static AjaxContext getCurrentInstance(FacesContext context) {
        AjaxContext ajaxContext = null;
        Map requestMap = null;
        if (null != context) {
            requestMap = context.getExternalContext().getRequestMap();
            ajaxContext = (AjaxContext)requestMap.get(AJAX_CONTEXT_KEY);
        }
        if (null == ajaxContext) {
            ajaxContext = AjaxContext.newInstance();
            if (null != context) {
                ajaxContext.context = context;
                requestMap.put(AJAX_CONTEXT_KEY, ajaxContext);
            }
        }
        return ajaxContext;
    }

    private static AjaxContext newInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ajaxContextClass = (Class<?>)contextClasses.get(loader);
        if (null == ajaxContextClass) {
            try {
                String resource = "META-INF/services/" + AjaxContext.class.getName();
                InputStream in = loader.getResourceAsStream(resource);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String ajaxContextClassName = reader.readLine();
                reader.close();
                ajaxContextClass = loader.loadClass(ajaxContextClassName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AjaxContext class set to " + ajaxContextClassName));
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AjaxContext class set to default implementation class");
                }
                ajaxContextClass = AjaxContext.class;
            }
            contextClasses.put(loader, ajaxContextClass);
        }
        try {
            return (AjaxContext)ajaxContextClass.newInstance();
        }
        catch (Exception e) {
            throw new FacesException("Error to create instance of AjaxContext", (Throwable)e);
        }
    }

    public static void clearCurrentInstance(FacesContext context) {
        Map requestMap = null;
        if (null != context) {
            requestMap = context.getExternalContext().getRequestMap();
            requestMap.remove(AJAX_CONTEXT_KEY);
        }
    }

    public static void setCurrentInstance(FacesContext context, AjaxContext ajaxContext) {
        Map requestMap = null;
        if (null != context) {
            requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(AJAX_CONTEXT_KEY, ajaxContext);
        }
    }

    public void renderSubmittedAjaxRegion() {
        this.renderSubmittedAjaxRegion(this.context);
    }

    public void renderSubmittedAjaxRegion(FacesContext context) {
        AjaxContainer ajax = AjaxRendererUtils.getSubmittedAjaxContainer(context, null);
        if (null != ajax) {
            this.renderAjaxRegion(context, (UIComponent)ajax, true);
        }
    }

    public void renderAjaxRegion(FacesContext context, UIComponent component, boolean useFilterWriter) throws FacesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.RENDER_AJAX_REQUEST, component.getId()));
        }
        try {
            PrintWriter servletWriter;
            this.setSelfRender(true);
            ExternalContext extContext = context.getExternalContext();
            RenderKit renderKit = context.getRenderKit();
            ServletRequest request = (ServletRequest)extContext.getRequest();
            ServletResponse response = (ServletResponse)extContext.getResponse();
            String contentType = "text/xml";
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            response.setContentType(contentType + "; charset=" + encoding);
            if (useFilterWriter && extContext.getRequestMap().containsKey("com.exade.vcp.Filter.ResponseWrapper")) {
                ServletResponse servletResponse = (ServletResponse)extContext.getRequestMap().get("com.exade.vcp.Filter.ResponseWrapper");
                servletResponse.resetBuffer();
                servletWriter = servletResponse.getWriter();
                ((FilterServletResponseWrapper)servletResponse).setUseNullStream(true);
            } else {
                servletWriter = response.getWriter();
            }
            ResponseWriter writer = renderKit.createResponseWriter((Writer)servletWriter, null, encoding);
            context.setResponseWriter(writer);
            writer.startDocument();
            this.encodeAjaxBegin(context, component);
            component.encodeBegin(context);
            ((AjaxContainer)component).encodeAjax(context);
            component.encodeEnd(context);
            this.encodeAjaxEnd(context, component);
            this.processHeadResources(context);
            writer.endDocument();
            writer.flush();
            writer.close();
            servletWriter.close();
        }
        catch (IOException e) {
            throw new FacesException(Messages.getMessage(Messages.RENDERING_AJAX_REGION_ERROR, component.getClientId(context)), (Throwable)e);
        }
        finally {
            context.responseComplete();
        }
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxRendererUtils.encodeAjaxEnd(context, component);
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        AjaxRendererUtils.encodeAjaxBegin(context, component);
    }

    public void processHeadResources(FacesContext context) throws FacesException {
        ExternalContext externalContext = context.getExternalContext();
        if (null != externalContext.getRequestMap().get("com.exade.vcp.Filter.ResponseWrapper")) {
            UIViewRoot root = context.getViewRoot();
            LinkedHashSet scripts = new LinkedHashSet();
            LinkedHashSet<String> styles = new LinkedHashSet<String>();
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            this.processHeadResources(context, (UIComponent)root, scripts, styles, renderKit);
            if (scripts.size() > 0) {
                externalContext.getRequestMap().put(SCRIPTS_PARAMETER, scripts);
            }
            String styleSheetUri = null;
            try {
                styleSheetUri = (String)SkinFactory.getInstance().getSkin(context).getParameter(context, "generalStyleSheet");
            }
            catch (SkinNotFoundException e) {
                log.warn((Object)"Current Skin is not found", (Throwable)((Object)e));
            }
            if (null != styleSheetUri) {
                String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, styleSheetUri);
                styles.add(resourceURL);
            }
            if (styles.size() > 0) {
                externalContext.getRequestMap().put(STYLES_PARAMETER, styles);
            }
        }
    }

    private void processHeadResources(FacesContext context, UIComponent root, Set scripts, Set styles, RenderKit renderKit) {
        UIComponent child;
        Renderer renderer = this.getRenderer(context, root, renderKit);
        if (null != renderer && renderer instanceof HeaderResourceProducer) {
            HeaderResourceProducer producer = (HeaderResourceProducer)renderer;
            LinkedHashSet set = producer.getHeaderScripts(context, root);
            if (null != set) {
                scripts.addAll(set);
            }
            if (null != (set = producer.getHeaderStyles(context, root))) {
                styles.addAll(set);
            }
        }
        Iterator<Object> iter = root.getFacets().values().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child, scripts, styles, renderKit);
        }
        iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child, scripts, styles, renderKit);
        }
    }

    private Renderer getRenderer(FacesContext context, UIComponent comp, RenderKit renderKit) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    public int getUniqueIdCounter() {
        return this.uniqueIdCounter++;
    }

    public void resetUniqueIdCounter() {
        this.uniqueIdCounter = 0;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public Set getAjaxAreasToRender() {
        return this.ajaxAreasToRender;
    }

    public void addComponentToAjaxRender(UIComponent component) {
        this.ajaxAreasToRender.add(AjaxRendererUtils.getAbsoluteId(component));
    }

    public void addComponentToAjaxRender(UIComponent base, String id) {
        this.ajaxAreasToRender.add(AjaxRendererUtils.convertId(base, id));
    }

    public Set getAjaxRenderedAreas() {
        return this.ajaxRenderedAreas;
    }

    public void addRenderedArea(String id) {
        this.ajaxRenderedAreas.add(id);
    }

    public boolean removeRenderedArea(String id) {
        return this.ajaxRenderedAreas.remove(id);
    }

    public String getSubmittedRegionClientId() {
        return this.submittedRegionClientId;
    }

    public void setSubmittedRegionClientId(String submittedClientId) {
        this.submittedRegionClientId = submittedClientId;
    }

    public UIComponent getSubmittedRegion() {
        return this.submittedRegion;
    }

    public void setSubmittedRegion(UIComponent submittedRegion) {
        this.submittedRegion = submittedRegion;
    }

    public String getSubmittedRegionId() {
        return this.submittedRegionId;
    }

    public void setSubmittedRegionId(String submittedRegionId) {
        this.submittedRegionId = submittedRegionId;
    }

    Buffer getAjaxEvents() {
        return this.ajaxEvents;
    }

    Buffer[] getEvents() {
        return this.events;
    }

    void clearEvents() {
        int len = PhaseId.VALUES.size();
        this.events = new Buffer[len];
        for (int i = 0; i < len; ++i) {
            this.events[i] = new UnboundedFifoBuffer();
        }
    }

    public boolean isSelfRender() {
        return this.selfRender;
    }

    public void setSelfRender(boolean selfRender) {
        this.selfRender = selfRender;
    }

    public ViewIdHolder getViewIdHolder() {
        return this.viewIdHolder;
    }

    public void setViewIdHolder(ViewIdHolder viewIdHolder) {
        this.viewIdHolder = viewIdHolder;
    }

    public Object getResponseData() {
        return this.responseDataMap.get(RESPONSE_DATA_KEY);
    }

    public void setResponseData(Object responseData) {
        this.responseDataMap.put(RESPONSE_DATA_KEY, responseData);
    }

    public Map getResponseDataMap() {
        return this.responseDataMap;
    }

    public void setResponseDataMap(Map responseDataMap) {
        this.responseDataMap = responseDataMap;
    }
}

