/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$socket$ServerThread == null ? (class$org$jboss$remoting$transport$socket$ServerThread = ServerThread.class$("org.jboss.remoting.transport.socket.ServerThread")) : class$org$jboss$remoting$transport$socket$ServerThread));
    protected SocketServerInvoker invoker;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected volatile boolean running = true;
    protected volatile boolean handlingResponse = true;
    protected volatile boolean shutdown = false;
    protected static int id = 0;
    private SocketWrapper socketWrapper = null;
    protected String serverSocketClass = (class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = ServerThread.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper).getName();
    private Constructor serverSocketConstructor = null;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerThread;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized int nextID() {
        int nextID = id++;
        return nextID;
    }

    public ServerThread(Socket socket, SocketServerInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout, String serverSocketClass) throws Exception {
        super("SocketServerInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID());
        this.serverSocketClass = serverSocketClass;
        this.socketWrapper = this.createServerSocket(socket, timeout, invoker.getLocator().getParameters());
        this.invoker = invoker;
        this.clientpool = clientpool;
        this.threadpool = threadpool;
    }

    public void shutdown() {
        this.shutdown = true;
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SocketWrapper createServerSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.serverSocketConstructor == null) {
            ClassLoader classLoader = null;
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<?> cl = classLoader.loadClass(this.serverSocketClass);
            try {
                this.serverSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = ServerThread.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = ServerThread.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            catch (NoSuchMethodException e) {
                this.serverSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket);
            }
        }
        SocketWrapper serverSocketWrapper = null;
        if (this.serverSocketConstructor.getParameterTypes().length == 3) {
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        } else {
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket);
            serverSocketWrapper.setTimeout(timeout);
        }
        return serverSocketWrapper;
    }

    public void evict() {
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void wakeup(Socket socket, int timeout, Map metadata) throws Exception {
        this.socketWrapper = this.createServerSocket(socket, timeout, metadata);
        String name = "SocketServerInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID();
        super.setName(name);
        this.running = true;
        this.handlingResponse = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                this.dorun();
                if (this.shutdown) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        this.clientpool.remove(this);
                        return;
                    }
                }
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        LinkedList linkedList = this.threadpool;
                        synchronized (linkedList) {
                            this.clientpool.remove(this);
                            this.threadpool.add(this);
                            Thread.interrupted();
                            ((Object)((Object)this.clientpool)).notify();
                        }
                    }
                    log.debug((Object)"begin thread wait");
                    this.wait();
                    log.debug((Object)"WAKEUP in SERVER THREAD");
                }
            }
        }
        catch (Exception exception) {
            log.debug((Object)"Exiting run on exception", (Throwable)exception);
            return;
        }
    }

    protected void acknowledge() throws Exception {
        this.handlingResponse = true;
        try {
            this.socketWrapper.checkConnection();
        }
        catch (EOFException e) {
            throw new AcknowledgeFailure();
        }
        catch (SocketException se) {
            throw new AcknowledgeFailure();
        }
        catch (IOException ioe) {
            throw new AcknowledgeFailure();
        }
        this.handlingResponse = false;
    }

    protected void processInvocation() throws Exception {
        this.handlingResponse = true;
        UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(this.invoker.getLocator(), this.getClass().getClassLoader());
        if (unmarshaller == null) {
            unmarshaller = MarshalFactory.getUnMarshaller(this.invoker.getDataType(), this.invoker.getSerializationType());
        }
        String serializationType = this.invoker.getLocator().findSerializationType();
        Object obj = unmarshaller.read(this.socketWrapper.getInputStream(), null);
        Object resp = null;
        try {
            boolean interrupted = Thread.interrupted();
            resp = this.invoker.invoke(obj);
        }
        catch (Exception ex) {
            resp = ex;
        }
        Thread.interrupted();
        Marshaller marshaller = MarshalFactory.getMarshaller(this.invoker.getLocator(), this.getClass().getClassLoader());
        if (marshaller == null) {
            marshaller = MarshalFactory.getMarshaller(this.invoker.getDataType(), this.invoker.getSerializationType());
        }
        marshaller.write(resp, this.socketWrapper.getOutputStream());
        this.handlingResponse = false;
    }

    protected void dorun() {
        log.debug((Object)"beginning dorun");
        this.running = true;
        this.handlingResponse = true;
        try {
            this.processInvocation();
        }
        catch (Exception ex) {
            log.error((Object)"failed to process invocation.", (Throwable)ex);
            this.running = false;
        }
        while (this.running) {
            block19: {
                try {
                    this.acknowledge();
                    this.processInvocation();
                }
                catch (AcknowledgeFailure e) {
                    if (!this.shutdown) {
                        log.trace((Object)"Keep alive acknowledge failed.");
                    }
                    this.running = false;
                }
                catch (InterruptedIOException e) {
                    if (!this.shutdown) {
                        log.error((Object)"socket timed out", (Throwable)e);
                    }
                    this.running = false;
                }
                catch (InterruptedException e) {
                    if (!this.shutdown) {
                        log.error((Object)"interrupted", (Throwable)e);
                    }
                }
                catch (EOFException eof) {
                    if (!this.shutdown) {
                        log.trace((Object)"EOF received.  This is likely due to client finishing comminication.");
                    }
                    this.running = false;
                }
                catch (Exception ex) {
                    if (this.shutdown) break block19;
                    log.error((Object)"failed", (Throwable)ex);
                    this.running = false;
                }
            }
            Thread.interrupted();
        }
        String serializationType = this.invoker.getLocator().findSerializationType();
        try {
            OutputStream out;
            InputStream in = this.socketWrapper.getInputStream();
            if (in != null) {
                in.close();
            }
            if ((out = this.socketWrapper.getOutputStream()) != null) {
                out.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.socketWrapper.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed cleanup", (Throwable)ex);
        }
        this.socketWrapper = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AcknowledgeFailure
    extends Exception {
    }
}

