/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.SocketServerInvoker;

public class MultiplexServerInvoker
extends SocketServerInvoker
implements Runnable {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker = MultiplexServerInvoker.class$("org.jboss.remoting.transport.multiplex.MultiplexServerInvoker")) : class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker));
    public static final String SERVER_MULTIPLEX_ID_KEY = "serverMultiplexId";
    public static final String CLIENT_MULTIPLEX_ID_KEY = "clientMultiplexId";
    public static final String BIND_HOST_KEY = "multiplexBindHost";
    public static final String BIND_PORT_KEY = "multiplexBindPort";
    public static final String CONNECT_HOST_KEY = "multiplexConnectHost";
    public static final String CONNECT_PORT_KEY = "multiplexConnectPort";
    private static Map socketGroupMap = Collections.synchronizedMap(new HashMap());
    private static Map addressPairMap = Collections.synchronizedMap(new HashMap());
    private boolean isVirtual = false;
    private Map virtualServerInvokers = Collections.synchronizedMap(new HashMap());
    private Socket connectPrimingSocket;
    private String socketGroupId;
    private SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private String bindHost;
    private int bindPort;
    private int originalBindPort;
    private InetAddress bindAddress;
    private InetSocketAddress connectSocketAddress;
    private boolean readyToStart = true;
    private boolean needsSocketGroupConfiguration = true;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexServerInvoker;

    public static Map getAddressPairMap() {
        return addressPairMap;
    }

    public static Map getSocketGroupMap() {
        return socketGroupMap;
    }

    public MultiplexServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public MultiplexServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected MultiplexServerInvoker(InvokerLocator locator, Map configuration, ServerSocket serverSocket, Socket socket) {
        super(locator, configuration);
        this.serverSocket = serverSocket;
        this.connectPrimingSocket = socket;
        this.isVirtual = true;
        this.needsSocketGroupConfiguration = false;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void start() throws IOException {
        this.setBindingInfo();
        Map parameters = this.locator.getParameters();
        if (parameters != null && this.needsSocketGroupConfiguration) {
            this.configureSocketGroupParameters(parameters);
        }
        if (this.readyToStart) {
            this.finishStart();
        }
    }

    public void run() {
        if (this.trace) {
            log.trace((Object)"Started execution of method run");
        }
        while (this.running) {
            try {
                if (this.trace) {
                    log.trace((Object)"Socket is going to be accepted");
                }
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    log.trace((Object)("Accepted: " + socket));
                }
                this.processInvocation(socket);
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                log.error((Object)"Failed to accept socket connection", ex);
                this.stop();
                return;
            }
        }
    }

    protected void setup() throws Exception {
        this.originalBindPort = this.getLocator().getPort();
        super.setup();
    }

    protected void finishStart() throws IOException {
        log.debug((Object)"entering finishStart()");
        if (this.isStarted()) {
            return;
        }
        if (this.socketGroupInfo != null && this.connectSocketAddress == null) {
            InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
            int connectPort = this.socketGroupInfo.getConnectPort();
            this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
        }
        try {
            super.start();
        }
        catch (IOException e) {
            log.error((Object)"Error starting MultiplexServerInvoker.", (Throwable)e);
            this.cleanup();
        }
        if (this.running) {
            log.debug((Object)"MultiplexServerInvoker started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configureSocketGroupParameters(Map parameters) throws IOException {
        log.debug((Object)"entering configureSocketGroupParameters()");
        log.debug((Object)this.locator);
        int connectPort = -1;
        this.socketGroupId = (String)parameters.get(SERVER_MULTIPLEX_ID_KEY);
        Map map = socketGroupMap;
        synchronized (map) {
            if (this.socketGroupId != null && (this.socketGroupInfo = (SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId)) != null) {
                log.debug((Object)"server rule 1");
                InetAddress socketGroupBindAddress = this.socketGroupInfo.getBindAddress();
                int socketGroupBindPort = this.socketGroupInfo.getBindPort();
                if (socketGroupBindAddress != null && !socketGroupBindAddress.equals(this.bindAddress)) {
                    String message = "socket group bind address (" + socketGroupBindAddress + ") does not match bind address (" + this.bindAddress + ")";
                    log.error((Object)message);
                    throw new IOException(message);
                }
                if (socketGroupBindPort > 0 && this.originalBindPort > 0 && socketGroupBindPort != this.bindPort) {
                    String message = "socket group bind port (" + socketGroupBindPort + ") does not match bind port (" + this.bindPort + ")";
                    log.error((Object)message);
                    throw new IOException(message);
                }
                if (this.originalBindPort <= 0 && socketGroupBindPort > 0) {
                    this.bindPort = socketGroupBindPort;
                }
                this.isVirtual = true;
                InetAddress connectAddress = this.socketGroupInfo.getConnectAddress();
                connectPort = this.socketGroupInfo.getConnectPort();
                this.connectSocketAddress = new InetSocketAddress(connectAddress, connectPort);
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                this.socketGroupInfo.setServerInvoker(this);
                this.socketGroupInfo.getClientInvoker().finishStart();
                this.readyToStart = true;
                if (this.socketGroupInfo.getPrimingSocket() == null) {
                    MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectAddress.getHostName(), connectPort, this.bindAddress, this.bindPort);
                }
                return;
            }
            String connectHost = (String)parameters.get(CONNECT_HOST_KEY);
            String connectPortString = (String)parameters.get(CONNECT_PORT_KEY);
            if (connectHost != null && connectPortString == null) {
                throw new IOException("connectHost != null and connectPort == null");
            }
            if (connectHost == null && connectPortString != null) {
                throw new IOException("connectHost == null and connectPort != null");
            }
            if (connectHost != null) {
                log.debug((Object)"server rule 2");
                this.isVirtual = true;
                try {
                    connectPort = Integer.parseInt(connectPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("number format error for callbackPort: " + connectPortString);
                }
                this.connectSocketAddress = new InetSocketAddress(connectHost, connectPort);
                this.addressPair = new AddressPair(connectHost, connectPort, this.bindHost, this.bindPort);
                this.socketGroupInfo = (SocketGroupInfo)addressPairMap.get(this.addressPair);
                if (this.socketGroupInfo != null) {
                    this.socketGroupInfo.setBindAddress(this.bindAddress);
                    this.socketGroupInfo.setBindPort(this.bindPort);
                    this.socketGroupInfo.setServerInvoker(this);
                    this.readyToStart = true;
                    return;
                }
                this.socketGroupInfo = new SocketGroupInfo();
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                this.socketGroupInfo.setServerInvoker(this);
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, connectPort, this.bindAddress, this.bindPort);
                addressPairMap.put(this.addressPair, this.socketGroupInfo);
                if (this.socketGroupId != null) {
                    socketGroupMap.put(this.socketGroupId, this.socketGroupInfo);
                }
                this.readyToStart = true;
                return;
            }
            if (this.socketGroupId != null) {
                log.debug((Object)"server rule 3");
                this.socketGroupInfo = new SocketGroupInfo();
                this.socketGroupInfo.setServerInvoker(this);
                this.socketGroupInfo.setBindAddress(this.bindAddress);
                this.socketGroupInfo.setBindPort(this.bindPort);
                socketGroupMap.put(this.socketGroupId, this.socketGroupInfo);
                this.isVirtual = true;
                this.readyToStart = false;
                return;
            }
            log.debug((Object)"server rule 4");
            this.isVirtual = false;
            this.readyToStart = true;
        }
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort) throws IOException {
        MultiplexServerInvoker.createPrimingSocket(socketGroupInfo, connectHost, connectPort, null, -1);
    }

    protected static void createPrimingSocket(SocketGroupInfo socketGroupInfo, String connectHost, int connectPort, InetAddress bindAddress, int bindPort) throws IOException {
        log.debug((Object)"entering createPrimingSocket()");
        boolean needed = true;
        InetSocketAddress csa = new InetSocketAddress(connectHost, connectPort);
        if (bindAddress != null) {
            InetSocketAddress bsa = new InetSocketAddress(bindAddress, bindPort);
            needed = !MultiplexingManager.checkForShareableManagerByAddressPair(bsa, csa);
        } else {
            boolean bl = needed = !MultiplexingManager.checkForShareableManager(csa);
        }
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocketNeeded(needed);
        }
        if (!needed) {
            log.debug((Object)"priming socket is not necessary");
            return;
        }
        VirtualSocket socket = null;
        socket = bindAddress != null ? new VirtualSocket(connectHost, connectPort, bindAddress, bindPort) : new VirtualSocket(connectHost, connectPort);
        if (socketGroupInfo != null) {
            socketGroupInfo.setPrimingSocket(socket);
        }
        MultiplexingManager manager = socket.getManager();
        while (!manager.isRemoteServerSocketRegistered()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        log.debug((Object)"created priming socket");
    }

    protected String getThreadName(int i) {
        String virtualTag = this.isVirtual ? "v" : "m";
        return "MultiplexServerInvoker#" + i + virtualTag + "-" + this.getServerBindPort();
    }

    protected void processInvocation(Socket socket) throws Exception {
        if (this.isVirtual) {
            super.processInvocation(socket);
        } else {
            log.debug((Object)"creating VSS");
            VirtualServerSocket ss = new VirtualServerSocket((VirtualSocket)socket);
            MultiplexServerInvoker si = new MultiplexServerInvoker(this.locator, this.getConfiguration(), ss, socket);
            si.callbackHandlers = this.callbackHandlers;
            si.clientCallbackListener = this.clientCallbackListener;
            si.handlers = this.handlers;
            this.virtualServerInvokers.put(socket.getRemoteSocketAddress(), si);
            si.create();
            si.start();
            log.debug((Object)("created virtual MultiplexServerInvoker: " + si));
        }
    }

    protected void cleanup() {
        log.debug((Object)"entering MultiplexServerInvoker.cleanup()");
        super.cleanup();
        if (this.isVirtual) {
            if (this.connectPrimingSocket != null) {
                log.debug((Object)"MultiplexServerInvoker: closing connect priming socket");
                try {
                    this.connectPrimingSocket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing connect priming socket during cleanup upon stopping", (Throwable)e);
                }
            }
        } else {
            Iterator it = this.virtualServerInvokers.values().iterator();
            while (it.hasNext()) {
                ((ServerInvoker)it.next()).stop();
                it.remove();
            }
        }
        if (this.socketGroupInfo != null) {
            this.socketGroupInfo.setServerInvoker(null);
            VirtualSocket ps = null;
            if (this.socketGroupInfo.getClientInvoker() == null && (ps = this.socketGroupInfo.getPrimingSocket()) != null) {
                log.debug((Object)"MultiplexServerInvoker: closing bind priming socket");
                try {
                    ((Socket)ps).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing bind priming socket during cleanup upon stopping", (Throwable)e);
                }
            }
        }
        if (this.socketGroupId != null) {
            MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
        }
        if (this.addressPair != null) {
            MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
        }
    }

    protected ServerSocket createServerSocket(int bindPort, int backlog, InetAddress bindAddress) throws IOException {
        if (this.serverSocket != null) {
            return this.serverSocket;
        }
        ServerSocket svrSocket = null;
        if (this.isVirtual) {
            InetSocketAddress bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
            svrSocket = new VirtualServerSocket(this.connectSocketAddress, bindSocketAddress, this.getSocketTimeout());
            if (this.socketGroupInfo != null) {
                this.socketGroupInfo.setPrimingSocketNeeded(false);
            }
        } else {
            svrSocket = new MasterServerSocket(bindPort, backlog, bindAddress);
        }
        log.debug((Object)("Created " + svrSocket.getClass() + ": " + svrSocket));
        svrSocket.setSoTimeout(this.timeout);
        return svrSocket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public MultiplexServerInvoker getServerInvoker(InetSocketAddress address) {
        Iterator it = this.virtualServerInvokers.keySet().iterator();
        while (it.hasNext()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)it.next();
        }
        return (MultiplexServerInvoker)this.virtualServerInvokers.get(address);
    }

    public Collection getServerInvokers() {
        return this.virtualServerInvokers.values();
    }

    protected void setBindingInfo() throws IOException {
        String originalUri = this.getLocator().getOriginalURI();
        String pastProtocol = originalUri.substring(originalUri.indexOf("://") + 3);
        int colon = pastProtocol.indexOf(":");
        int slash = pastProtocol.indexOf("/");
        String originalHost = null;
        int originalPort = 0;
        if (colon != -1) {
            originalHost = pastProtocol.substring(0, colon).trim();
            originalPort = slash > -1 ? Integer.parseInt(pastProtocol.substring(colon + 1, slash)) : Integer.parseInt(pastProtocol.substring(colon + 1));
        } else {
            originalHost = slash > -1 ? pastProtocol.substring(0, slash).trim() : pastProtocol.substring(0).trim();
        }
        this.bindHost = this.getServerBindAddress();
        this.bindPort = this.getServerBindPort();
        this.bindAddress = InetAddress.getByName(this.bindHost);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SocketGroupInfo {
        private MultiplexClientInvoker clientInvoker;
        private MultiplexServerInvoker serverInvoker;
        private boolean primingSocketNeeded;
        private VirtualSocket primingSocket;
        private InetAddress connectAddress;
        private int connectPort;
        private InetAddress bindAddress;
        private int bindPort;

        protected SocketGroupInfo() {
        }

        public InetAddress getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public int getBindPort() {
            return this.bindPort;
        }

        public void setBindPort(int bindPort) {
            this.bindPort = bindPort;
        }

        public MultiplexClientInvoker getClientInvoker() {
            return this.clientInvoker;
        }

        public void setClientInvoker(MultiplexClientInvoker clientInvoker) {
            this.clientInvoker = clientInvoker;
        }

        public InetAddress getConnectAddress() {
            return this.connectAddress;
        }

        public void setConnectAddress(InetAddress connectAddress) {
            this.connectAddress = connectAddress;
        }

        public int getConnectPort() {
            return this.connectPort;
        }

        public void setConnectPort(int connectPort) {
            this.connectPort = connectPort;
        }

        public boolean getPrimingSocketNeeded() {
            return this.primingSocketNeeded;
        }

        public void setPrimingSocketNeeded(boolean primingSocketNeeded) {
            this.primingSocketNeeded = primingSocketNeeded;
        }

        public VirtualSocket getPrimingSocket() {
            return this.primingSocket;
        }

        public void setPrimingSocket(VirtualSocket primingSocket) {
            this.primingSocket = primingSocket;
        }

        public MultiplexServerInvoker getServerInvoker() {
            return this.serverInvoker;
        }

        public void setServerInvoker(MultiplexServerInvoker serverInvoker) {
            this.serverInvoker = serverInvoker;
        }
    }
}

