/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.AddressPair;
import org.jboss.remoting.transport.socket.SocketClientInvoker;

public class MultiplexClientInvoker
extends SocketClientInvoker {
    private InetAddress connectAddress;
    private String connectHost;
    private int connectPort;
    private InetSocketAddress connectSocketAddress;
    private InetSocketAddress bindSocketAddress;
    private String socketGroupId;
    private MultiplexServerInvoker.SocketGroupInfo socketGroupInfo;
    private AddressPair addressPair;
    private boolean readyToRun = true;
    protected String clientSocketClassName = (class$org$jboss$remoting$transport$socket$ClientSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ClientSocketWrapper = MultiplexClientInvoker.class$("org.jboss.remoting.transport.socket.ClientSocketWrapper")) : class$org$jboss$remoting$transport$socket$ClientSocketWrapper).getName();
    private Constructor clientSocketConstructor = null;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ClientSocketWrapper;

    public MultiplexClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
    }

    protected void setup() throws Exception {
        this.log.debug((Object)("configuring MultiplexClientInvoker for: " + this.locator));
        super.setup();
        this.connectAddress = InetAddress.getByName(this.locator.getHost());
        this.connectHost = this.connectAddress.getHostName();
        this.connectPort = this.locator.getPort();
        this.connectSocketAddress = new InetSocketAddress(this.connectAddress, this.connectPort);
        Map parameters = this.locator.getParameters();
        if (parameters != null) {
            this.configureSocketGroupParameters(parameters);
        }
    }

    public synchronized void finishStart() {
        if (this.socketGroupInfo != null && this.bindSocketAddress == null) {
            InetAddress bindAddress = this.socketGroupInfo.getBindAddress();
            int bindPort = this.socketGroupInfo.getBindPort();
            this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
        }
        this.readyToRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureSocketGroupParameters(Map parameters) throws IOException {
        int bindPort = -1;
        InetAddress bindAddress = null;
        this.socketGroupId = (String)parameters.get("clientMultiplexId");
        Map map = MultiplexServerInvoker.getSocketGroupMap();
        synchronized (map) {
            if (this.socketGroupId != null && (this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId)) != null) {
                bindAddress = this.socketGroupInfo.getBindAddress();
                bindPort = this.socketGroupInfo.getBindPort();
                this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.setClientInvoker(this);
                if (this.socketGroupInfo.getPrimingSocket() == null) {
                    String connectHost = this.connectAddress.getHostName();
                    MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort);
                }
                this.socketGroupInfo.getServerInvoker().finishStart();
                this.finishStart();
                return;
            }
            String bindHost = (String)parameters.get("multiplexBindHost");
            String bindPortString = (String)parameters.get("multiplexBindPort");
            if (bindHost != null && bindPortString == null) {
                bindPortString = "0";
            }
            if (bindHost == null && bindPortString != null) {
                bindHost = "localhost";
            }
            if (bindHost != null) {
                try {
                    bindPort = Integer.parseInt(bindPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("number format error for bindPort: " + bindPortString);
                }
                this.bindSocketAddress = new InetSocketAddress(bindHost, bindPort);
                this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
                this.socketGroupInfo = (MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getAddressPairMap().get(this.addressPair);
                if (this.socketGroupInfo != null) {
                    this.socketGroupInfo.setConnectAddress(this.connectAddress);
                    this.socketGroupInfo.setConnectPort(this.connectPort);
                    this.socketGroupInfo.setClientInvoker(this);
                    this.finishStart();
                    return;
                }
                this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.setClientInvoker(this);
                bindAddress = InetAddress.getByName(bindHost);
                String connectHost = this.connectAddress.getHostName();
                MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort);
                MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
                if (this.socketGroupId != null) {
                    MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                }
                this.finishStart();
                return;
            }
            if (this.socketGroupId != null) {
                this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
                this.socketGroupInfo.setConnectAddress(this.connectAddress);
                this.socketGroupInfo.setConnectPort(this.connectPort);
                this.socketGroupInfo.setClientInvoker(this);
                MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
                return;
            }
            String connectHost = this.connectAddress.getHostName();
            MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort);
            this.finishStart();
        }
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        this.log.debug((Object)"entering transport()");
        if (!this.readyToRun) {
            throw new IOException("connection to server has not been made");
        }
        return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
    }

    protected void handleDisconnect() {
        this.log.debug((Object)"entering handleDisconnect()");
        super.handleDisconnect();
        if (this.socketGroupInfo != null) {
            this.socketGroupInfo.setClientInvoker(null);
            if (this.socketGroupInfo.getServerInvoker() == null && this.socketGroupInfo.getPrimingSocket() != null) {
                this.log.info((Object)"MultiplexClientInvoker: closing bind priming socket");
                try {
                    this.socketGroupInfo.getPrimingSocket().close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error closing bind priming socket during cleanup upon stopping", (Throwable)e);
                }
            }
        }
        if (this.socketGroupId != null) {
            MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
        }
        if (this.addressPair != null) {
            MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
        }
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public int getSocketTimeout() {
        return this.timeout;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        this.log.debug((Object)"MultiplexClientInvoker.createSocket()");
        VirtualSocket socket = new VirtualSocket();
        socket.connect(this.connectSocketAddress, this.bindSocketAddress, this.timeout);
        return socket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

