/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.complex2.client;

import java.util.ArrayList;
import org.jboss.remoting.samples.complex.Address;
import org.jboss.remoting.samples.complex.Customer;
import org.jboss.remoting.samples.complex2.Order;
import org.jboss.remoting.samples.complex2.OrderProcessor;
import org.jboss.remoting.samples.complex2.client.OrderProcessorClient;

public class ComplexClient {
    public void makeInvocation() throws Throwable {
        Order order = this.createOrder();
        OrderProcessor processor = OrderProcessorClient.getOrderProcessor();
        System.out.println("Order to be processed: " + order);
        Order changedOrder = processor.processOrder(order);
        System.out.println("Order now processed " + changedOrder);
    }

    private Order createOrder() {
        Order order = new Order();
        Customer customer = this.createCustomer();
        order.setCustomer(customer);
        ArrayList<String> items = new ArrayList<String>();
        items.add("Xbox 360");
        items.add("Wireless controller");
        items.add("Ghost Recon 3");
        order.setItems(items);
        return order;
    }

    private Customer createCustomer() {
        Customer cust = new Customer();
        cust.setFirstName("Bob");
        cust.setLastName("Smith");
        Address addr = new Address();
        addr.setStreet("101 Oak Stree");
        addr.setCity("Atlanata");
        addr.setZip(30249);
        cust.setAddr(addr);
        return cust;
    }

    public static void main(String[] args) {
        ComplexClient client = new ComplexClient();
        try {
            client.makeInvocation();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

