/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.complex.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.NameBasedInvocation;

public class GenricProcessorClient
implements InvocationHandler {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private static Client remotingClient = null;
    private static GenricProcessorClient internalInstance = null;

    private static void init() throws Throwable {
        String locatorURI = transport + "://" + host + ":" + port;
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        remotingClient = new Client(locator);
    }

    public static Object getProcessor(Class targetClass) throws Throwable {
        if (remotingClient == null) {
            GenricProcessorClient.init();
        }
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{targetClass}, (InvocationHandler)internalInstance);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String[] paramSig = this.createParamSignature(args);
        NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
        Object response = remotingClient.invoke(request);
        return response;
    }

    private String[] createParamSignature(Object[] args) {
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getClass().getName();
        }
        return paramSig;
    }

    static {
        internalInstance = new GenricProcessorClient();
    }
}

