/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyValueMetaData
extends AbstractValueMetaData {
    protected KernelController controller;
    protected String property;
    protected ControllerState dependentState = ControllerState.INSTALLED;

    public AbstractDependencyValueMetaData() {
    }

    public AbstractDependencyValueMetaData(Object value) {
        super(value);
    }

    public AbstractDependencyValueMetaData(Object value, String property) {
        super(value);
        this.property = property;
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        ControllerContext context;
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((context = this.controller.getContext(this.value, this.dependentState)) == null) {
            throw new Error("Should not be here - dependency failed! " + this);
        }
        Object result = context.getTarget();
        if (result != null && this.property != null) {
            KernelConfigurator configurator = this.controller.getKernel().getConfigurator();
            BeanInfo beanInfo = configurator.getBeanInfo(result.getClass());
            TargettedJoinpoint joinpoint = configurator.getPropertyGetterJoinPoint(beanInfo, this.property);
            joinpoint.setTarget(result);
            return joinpoint.dispatch();
        }
        return result;
    }

    public void visit(MetaDataVisitor visitor) {
        KernelControllerContext controllerContext = visitor.getControllerContext();
        this.controller = (KernelController)controllerContext.getController();
        Object name = controllerContext.getName();
        Object iDependOn = this.getUnderlyingValue();
        ControllerState whenRequired = visitor.getContextState();
        AbstractDependencyItem item = new AbstractDependencyItem(name, iDependOn, whenRequired, this.dependentState);
        visitor.addDependency((DependencyItem)item);
        super.visit(visitor);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.property != null) {
            buffer.append(" property=").append(this.property);
        }
        if (this.dependentState != null) {
            buffer.append(" dependentState=").append(this.dependentState.getStateString());
        }
    }
}

