/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.taglib.ajax;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxListenerHelper;
import org.ajax4jsf.framework.ajax.AjaxSource;
import org.ajax4jsf.framework.util.message.Messages;

public class AjaxListenerTag
extends TagSupport {
    private static final long serialVersionUID = 2576519366310474212L;
    private String type = null;
    private String binding = null;

    public void setType(String type) {
        this.type = type;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public int doStartTag() throws JspException {
        if (this.type == null) {
            throw new JspException(Messages.getMessage(Messages.NULL_TYPE_ATTRIBUTE_ERROR));
        }
        UIComponentTag componentTag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (componentTag == null) {
            throw new JspException(Messages.getMessage(Messages.NO_UI_COMPONENT_TAG_ANCESTOR_ERROR, "AjaxListenerTag"));
        }
        if (componentTag.getCreated()) {
            UIComponent component = componentTag.getComponentInstance();
            if (component instanceof AjaxSource) {
                AjaxListener listener;
                if (null != this.binding) {
                    ValueBinding valueBinding;
                    try {
                        valueBinding = FacesContext.getCurrentInstance().getApplication().createValueBinding(this.binding);
                    }
                    catch (ReferenceSyntaxException e) {
                        throw new JspException((Throwable)e);
                    }
                    listener = new AjaxListenerHelper(valueBinding);
                } else {
                    String className;
                    if (UIComponentTag.isValueReference((String)this.type)) {
                        FacesContext facesContext = FacesContext.getCurrentInstance();
                        ValueBinding valueBinding = facesContext.getApplication().createValueBinding(this.type);
                        className = (String)valueBinding.getValue(facesContext);
                    } else {
                        className = this.type;
                    }
                    try {
                        listener = (AjaxListener)Class.forName(className).newInstance();
                    }
                    catch (Exception e) {
                        throw new JspException(Messages.getMessage(Messages.INSTANTIATE_LISTENER_ERROR, className, component.getId()), (Throwable)e);
                    }
                }
                ((AjaxSource)component).addAjaxListener(listener);
            } else {
                throw new JspException(Messages.getMessage(Messages.NOT_AJAX_CONTAINER_ERROR, component.getId()));
            }
        }
        return 0;
    }
}

