/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.framework.ViewHandlerWrapper;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.ajax.AjaxViewRootRIOneOne;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxViewHandler
extends ViewHandlerWrapper {
    public static final String STATE_MARKER_KEY = "org.ajax4jsf.view.state";
    public static final String SERIALIZED_STATE_KEY = "org.ajax4jsf.view.serializedstate";
    private static final Log _log = LogFactory.getLog((Class)AjaxViewHandler.class);
    private static final String REDIRECTED = "org.ajax4jsf.view.REDIRECTED";

    public AjaxViewHandler(ViewHandler parent) {
        super(parent);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot riRoot;
        ViewIdHolder viewIdHolder = AjaxContext.getCurrentInstance(facesContext).getViewIdHolder();
        if (null != viewIdHolder && viewIdHolder.skipNavigation(viewId)) {
            viewIdHolder.setViewId(viewId);
            riRoot = facesContext.getViewRoot();
        } else {
            UIViewRoot root = super.createView(facesContext, viewId);
            if (null == root || root instanceof AjaxViewRoot) {
                riRoot = root;
            } else {
                riRoot = new AjaxViewRootRIOneOne();
                riRoot.setViewId(root.getViewId());
                riRoot.setLocale(root.getLocale());
                String renderKitId = root.getRenderKitId();
                if (null == renderKitId) {
                    renderKitId = this.calculateRenderKitId(facesContext);
                }
                riRoot.setRenderKitId(renderKitId);
            }
            if (AjaxRendererUtils.isAjaxRequest(facesContext)) {
                AjaxContext.clearCurrentInstance(facesContext);
            }
        }
        return riRoot;
    }

    public void writeState(FacesContext context) throws IOException {
        if (AjaxContext.getCurrentInstance(context).isSelfRender()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("name", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.endElement("input");
        } else {
            super.writeState(context);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.restoreView(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        Map requestMap = externalContext.getRequestMap();
        if (null == viewRoot && requestParameterMap.containsKey("AJAXREQUEST") && !requestMap.containsKey(REDIRECTED)) {
            String actionURL = this.getActionURL(context, viewId);
            requestMap.put(REDIRECTED, Boolean.TRUE);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Detect session expiration in AJAX request - view don't restored, action URL is " + actionURL));
            }
            try {
                Object response = externalContext.getResponse();
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setHeader("Ajax-Expired", Messages.getMessage("AJAX_VIEW_EXPIRED"));
                }
                actionURL = externalContext.encodeActionURL(actionURL);
                externalContext.redirect(actionURL);
            }
            catch (IOException e) {
                throw new FacesException("Error on redirect for reload expired page", (Throwable)e);
            }
        }
        return viewRoot;
    }

    public String getResourceURL(FacesContext context, String url) {
        String resourceURL;
        if (url.startsWith("resource://")) {
            InternetResource resource = InternetResourceBuilder.getInstance().createResource(null, url.substring(InternetResource.RESOURCE_URI_PREFIX_LENGTH));
            resourceURL = resource.getUri(context, null);
        } else {
            resourceURL = super.getResourceURL(context, url);
        }
        return resourceURL;
    }
}

