/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.ajax4jsf.framework.ajax.AjaxComponent;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxSource;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;

public abstract class AjaxActionComponent
extends UIComponentBase
implements ActionSource,
AjaxComponent,
AjaxSource {
    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] al = (ActionListener[])this.getFacesListeners(ActionListener.class);
        return al;
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            FacesContext context = this.getFacesContext();
            MethodBinding action = this.getActionListener();
            if (null != action) {
                action.invoke(context, new Object[]{event});
            }
            if (null != (action = this.getAction())) {
                ActionListener listener = context.getApplication().getActionListener();
                if (listener != null) {
                    listener.processAction((ActionEvent)event);
                }
            } else {
                context.renderResponse();
            }
        } else if (event instanceof AjaxEvent) {
            this.setupReRender();
        }
    }

    protected void setupReRender() {
        AjaxRendererUtils.addRegionsFromComponent((UIComponent)this, this.getFacesContext());
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent && event.getComponent() == this) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (this.isBypassUpdates()) {
                event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        AjaxListener[] al = (AjaxListener[])this.getFacesListeners(AjaxListener.class);
        return al;
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }
}

