/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.container;

import java.net.URI;
import javax.security.auth.container.AuthParam;

public class MessagePolicy {
    protected TargetPolicy[] targetPolicies = null;

    public MessagePolicy(TargetPolicy[] targetPolicies) {
        if (targetPolicies == null) {
            throw new IllegalArgumentException("specified targetPolicies is null");
        }
        this.targetPolicies = targetPolicies;
    }

    public TargetPolicy[] getTargetPolicies() {
        if (this.targetPolicies != null && this.targetPolicies.length == 0) {
            throw new IllegalStateException("Target Policies should not be of zero length");
        }
        return this.targetPolicies;
    }

    public static class TargetPolicy {
        public static final URI AUTHENTICATE_RECIPIENT = URI.create("http://jboss.org/security/auth/container/auth_recipient");
        public static final URI AUTHENTICATE_RECIPIENT_CONTENT = URI.create("http://jboss.org/security/auth/container/auth_recipient_content");
        public static final URI AUTHENTICATE_SOURCE = URI.create("http://jboss.org/security/auth/container/auth_source");
        public static final URI AUTHENTICATE_SOURCE_CONTENT = URI.create("http://jboss.org/security/auth/container/auth_source_content");
        protected URI protectionPolicy;
        protected Target[] targets;

        public TargetPolicy(Target[] targets, URI protectionPolicy) {
            this.targets = targets;
            this.protectionPolicy = protectionPolicy;
        }

        public URI getProtectionPolicy() {
            return this.protectionPolicy;
        }

        public Target[] getTargets() {
            if (this.targets != null && this.targets.length == 0) {
                throw new IllegalStateException(" Targets cannot be of length zero");
            }
            return this.targets;
        }
    }

    public static interface Target {
        public Object get(AuthParam var1);

        public void put(AuthParam var1, Object var2);

        public void remove(AuthParam var1);
    }
}

