/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.nio.ByteBuffer;
import org.jboss.tm.recovery.BatchLog;
import org.jboss.tm.recovery.TxCompletionHandler;

class PendingWriteRequest {
    static final int TYPE_TX_MULTI_TM = 1;
    static final int TYPE_TX_SINGLE_TM = 0;
    static final int TYPE_END = -1;
    private ByteBuffer buffer;
    private BatchLog log;
    private Latch latch;
    private TxCompletionHandler completionHandler;
    private Exception failure;
    private int type;

    PendingWriteRequest(ByteBuffer buffer, Latch latch, boolean multiTmTransaction) {
        this.buffer = buffer;
        this.latch = latch;
        this.log = null;
        this.type = multiTmTransaction ? 1 : 0;
    }

    PendingWriteRequest(ByteBuffer buffer, Latch latch, BatchLog log) {
        this.buffer = buffer;
        this.latch = latch;
        this.log = log;
        this.type = -1;
    }

    TxCompletionHandler waitTilDone() {
        try {
            this.latch.acquire();
            if (this.failure != null) {
                throw this.failure;
            }
            return this.completionHandler;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    int getType() {
        return this.type;
    }

    BatchLog getLogger() {
        return this.log;
    }

    void setCompletionHandler(TxCompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
    }

    void setFailure(Exception failure) {
        this.failure = failure;
    }
}

