/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import com.corejsf.ResourcePhaseListener;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;

public class UISpinner
extends UIInput {
    private static final String MORE = ".more";
    private static final String LESS = ".less";

    public UISpinner() {
        this.setConverter((Converter)new IntegerConverter());
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        this.encodeInputField(writer, clientId);
        this.encodeDecrementButton(context, writer, clientId);
        this.encodeIncrementButton(context, writer, clientId);
    }

    public void decode(FacesContext context) {
        String clientId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        int increment = requestMap.containsKey((clientId = this.getClientId(context)) + MORE) ? 1 : (requestMap.containsKey(clientId + LESS) ? -1 : 0);
        try {
            int submittedValue = Integer.parseInt((String)requestMap.get(clientId));
            int newValue = this.getIncrementedValue(submittedValue, increment);
            this.setSubmittedValue("" + newValue);
            this.setValid(true);
        }
        catch (NumberFormatException ex) {
            this.setSubmittedValue((String)requestMap.get(clientId));
        }
    }

    private void encodeInputField(ResponseWriter writer, String clientId) throws IOException {
        Integer size;
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("name", (Object)clientId, "clientId");
        Object v = this.getValue();
        if (v != null) {
            writer.writeAttribute("value", (Object)v.toString(), "value");
        }
        if ((size = (Integer)this.getAttributes().get("size")) != null) {
            writer.writeAttribute("size", (Object)size, "size");
        }
        writer.endElement("input");
    }

    private void encodeDecrementButton(FacesContext context, ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)"image", null);
        writer.writeAttribute("name", (Object)(clientId + LESS), null);
        writer.writeAttribute("src", (Object)ResourcePhaseListener.getURL(context, "/com/corejsf/images/triangle_down.png", null), null);
        writer.writeAttribute("value", (Object)"<", "value");
        writer.endElement("input");
    }

    private void encodeIncrementButton(FacesContext context, ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)"image", null);
        writer.writeAttribute("name", (Object)(clientId + MORE), null);
        writer.writeAttribute("src", (Object)ResourcePhaseListener.getURL(context, "/com/corejsf/images/triangle_up.png", null), null);
        writer.writeAttribute("value", (Object)">", "value");
        writer.endElement("input");
    }

    private int getIncrementedValue(int submittedValue, int increment) {
        Integer minimum = (Integer)this.getAttributes().get("minimum");
        Integer maximum = (Integer)this.getAttributes().get("maximum");
        int newValue = submittedValue + increment;
        if (!(minimum != null && newValue < minimum || maximum != null && newValue > maximum)) {
            return newValue;
        }
        return submittedValue;
    }
}

